/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kz.greetgo.kafka.consumer.Profile;

public class TopicsInProfile {
    public final Set<String> topics;
    public final Profile profile;

    private TopicsInProfile(Collection<String> topics, Profile profile) {
        this.topics = Set.copyOf(Objects.requireNonNull(topics, "v3wxo9flNI :: topics==null"));
        this.profile = Objects.requireNonNull(profile, "Zg1k5z831V :: profile == null");
    }

    private TopicsInProfile(Stream<String> topics, Profile profile) {
        this.topics = Objects.requireNonNull(topics, "lfb9OI97f9 :: topics==null").collect(Collectors.toUnmodifiableSet());
        this.profile = Objects.requireNonNull(profile, "nNN37N9len :: profile == null");
    }

    public static TopicsInProfile of(Collection<String> topics, String profile) {
        return new TopicsInProfile(topics, new Profile(profile));
    }

    public static TopicsInProfile of(Collection<String> topics) {
        return new TopicsInProfile(topics, new Profile(null));
    }

    public static TopicsInProfile of(Collection<String> topics, Profile profile) {
        return new TopicsInProfile(topics, profile);
    }

    public static TopicsInProfile of(Stream<String> topics, String profile) {
        return new TopicsInProfile(topics, new Profile(profile));
    }

    public static TopicsInProfile of(Stream<String> topics, Profile profile) {
        return new TopicsInProfile(topics, profile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicsInProfile that = (TopicsInProfile)o;
        return Objects.equals(this.topics, that.topics) && Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hash(this.topics, this.profile);
    }

    public static Set<TopicsInProfile> distinct(Collection<TopicsInProfile> source) {
        HashMap<Profile, Set> profileWithTopics = new HashMap<Profile, Set>();
        HashSet<String> topicsInNullProfile = new HashSet<String>();
        for (TopicsInProfile tip : source) {
            if (tip.profile == null) {
                topicsInNullProfile.addAll(tip.topics);
                continue;
            }
            profileWithTopics.computeIfAbsent(tip.profile, k -> new HashSet()).addAll(tip.topics);
        }
        HashSet<TopicsInProfile> ret = new HashSet<TopicsInProfile>();
        if (topicsInNullProfile.size() > 0) {
            ret.add(TopicsInProfile.of(topicsInNullProfile));
        }
        for (Map.Entry e : profileWithTopics.entrySet()) {
            Set topics = (Set)e.getValue();
            if (topics.size() <= 0) continue;
            ret.add(TopicsInProfile.of((Collection<String>)topics, (Profile)e.getKey()));
        }
        return Set.copyOf(ret);
    }

    public static Set<TopicsInProfile> prefixTopics(String topicPrefix, Set<TopicsInProfile> source) {
        if (topicPrefix == null || topicPrefix.isBlank()) {
            return source;
        }
        return source.stream().map(t -> t.prefixTopicWith(topicPrefix)).collect(Collectors.toUnmodifiableSet());
    }

    private TopicsInProfile prefixTopicWith(String topicPrefix) {
        if (topicPrefix == null || this.topics.isEmpty()) {
            return this;
        }
        return TopicsInProfile.of(this.topics.stream().map(s -> topicPrefix + s), this.profile);
    }

    public String toString() {
        return "TopicsInProfile{[" + this.topics.stream().sorted().collect(Collectors.joining(" ")) + "] in " + this.profile + "}";
    }
}

