/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.config;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventRegistration;
import kz.greetgo.kafka.util.Handler;
import kz.greetgo.kafka.util.HandlerList;
import kz.greetgo.kafka.util.LineUtil;
import kz.greetgo.kafka.util.Listener;

public abstract class AbstractTextLinesConfig
implements AutoCloseable {
    protected final EventConfigFile configFile;
    protected final HandlerList changeHandlers = new HandlerList();
    protected final AtomicReference<EventRegistration> changeEventRegistration = new AtomicReference<Object>(null);
    private final AtomicReference<Datum> savedDatum = new AtomicReference();

    protected AbstractTextLinesConfig(EventConfigFile configFile) {
        this.configFile = configFile;
    }

    public Listener addChangeHandler(Handler handler) {
        return this.changeHandlers.addHandler(handler);
    }

    @Override
    public void close() {
        this.configFile.close();
    }

    protected void writeLines(List<String> lines) {
        this.configFile.writeContent(String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8));
    }

    protected List<String> readLines() {
        byte[] content = this.configFile.readContent();
        if (content == null) {
            return null;
        }
        return Arrays.stream(new String(content, StandardCharsets.UTF_8).split("\n")).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureChangeListener() {
        if (this.changeEventRegistration.get() != null) {
            return;
        }
        AbstractTextLinesConfig abstractTextLinesConfig = this;
        synchronized (abstractTextLinesConfig) {
            if (this.changeEventRegistration.get() != null) {
                return;
            }
            this.configFile.ensureLookingFor();
            EventRegistration er = this.changeEventRegistration.getAndSet(this.configFile.addEventHandler(this::happenedFileEvent));
            if (er != null) {
                er.unregister();
            }
        }
    }

    private void happenedFileEvent(ConfigEventType type) {
        if (type == ConfigEventType.DELETE) {
            return;
        }
        this.savedDatum.set(null);
        this.changeHandlers.fire();
    }

    protected abstract List<String> createDefaultLines();

    protected Map<String, String> readData() {
        return this.readData(null);
    }

    protected Map<String, String> readData(String keyHaveToBeExist) {
        Datum datum = this.savedDatum.get();
        if (datum != null && (keyHaveToBeExist == null || datum.existsKeys.contains(keyHaveToBeExist))) {
            return datum.data;
        }
        this.ensureChangeListener();
        List<String> defaultLines = this.createDefaultLines();
        List<String> lines = this.readLines();
        if (lines == null) {
            lines = new ArrayList<String>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            lines.add("");
            lines.add("#");
            lines.add("# Created at " + sdf.format(new Date()));
            lines.add("#");
            lines.add("");
            lines.addAll(defaultLines);
            return this.extractData_Save_WriteLines(keyHaveToBeExist, lines, true);
        }
        List<String> deltaLines = LineUtil.calcDelta(defaultLines, lines);
        if (deltaLines == null) {
            return this.extractData_Save_WriteLines(keyHaveToBeExist, lines, false);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        lines.add("");
        lines.add("#");
        lines.add("# Appended at " + sdf.format(new Date()));
        lines.add("#");
        lines.add("");
        lines.addAll(deltaLines);
        return this.extractData_Save_WriteLines(keyHaveToBeExist, lines, true);
    }

    private Map<String, String> extractData_Save_WriteLines(String key, List<String> lines, boolean linesChanged) {
        Objects.requireNonNull(lines, "4FRWHsCnLI :: lines == null");
        Datum datum = AbstractTextLinesConfig.linesToDatum(lines);
        if (key != null && !datum.existsKeys.contains(key)) {
            lines.add("");
            lines.add("#");
            lines.add("# Unknown parameter");
            lines.add(key);
            this.writeLines(lines);
            this.savedDatum.set(datum);
            return datum.data;
        }
        if (linesChanged) {
            this.writeLines(lines);
        }
        this.savedDatum.set(datum);
        return datum.data;
    }

    private static Datum linesToDatum(List<String> lines) {
        Datum datum = new Datum();
        for (String line : lines) {
            String trimmedLine;
            if (line == null || (trimmedLine = line.trim()).startsWith("#")) continue;
            int idx = line.indexOf("=");
            if (idx < 0) {
                datum.existsKeys.add(trimmedLine);
                continue;
            }
            String key = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            datum.existsKeys.add(key);
            datum.data.put(key, value);
        }
        return datum;
    }

    private static class Datum {
        final Map<String, String> data = new HashMap<String, String>();
        final Set<String> existsKeys = new HashSet<String>();

        private Datum() {
        }
    }
}

