/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kz.greetgo.kafka.consumer.ParameterValueValidator;
import kz.greetgo.kafka.consumer.ParameterValueValidatorInt;
import kz.greetgo.kafka.consumer.ParameterValueValidatorLong;
import kz.greetgo.kafka.consumer.ParameterValueValidatorStr;
import kz.greetgo.kafka.consumer.config.ParameterDefinition;

public class ConsumerConfigDefaults {
    private final List<ParameterDefinition> parameterDefinitionList = new ArrayList<ParameterDefinition>();
    private final Map<String, ParameterDefinition> parameterDefinitionMap = new HashMap<String, ParameterDefinition>();
    private static final Map<String, ParameterValueValidator> validatorMap;
    private static final ParameterDefinition DEFAULT_PARAMETER_DEFINITION;

    public static ConsumerConfigDefaults withDefaults() {
        ConsumerConfigDefaults consumerConfigDefaults = new ConsumerConfigDefaults();
        consumerConfigDefaults.addDefaults();
        return consumerConfigDefaults;
    }

    public void addDefaults() {
        this.addDefinition(" Long   con.auto.commit.interval.ms           1000  ");
        this.addDefinition(" Long   con.fetch.min.bytes                      1  ");
        this.addDefinition(" Long   con.max.partition.fetch.bytes      1048576  ");
        this.addDefinition(" Long   con.connections.max.idle.ms         540000  ");
        this.addDefinition(" Long   con.default.api.timeout.ms           60000  ");
        this.addDefinition(" Long   con.fetch.max.bytes               52428800  ");
        this.addDefinition(" Long   con.retry.backoff.ms                  2000  ");
        this.addDefinition(" Long   con.session.timeout.ms               10000  ");
        this.addDefinition(" Long   con.heartbeat.interval.ms             3000  ");
        this.addDefinition(" Long   con.max.poll.interval.ms           3000000  ");
        this.addDefinition(" Long   con.max.poll.records                   500  ");
        this.addDefinition(" Long   con.receive.buffer.bytes             65536  ");
        this.addDefinition(" Long   con.request.timeout.ms               30000  ");
        this.addDefinition(" Long   con.send.buffer.bytes               131072  ");
        this.addDefinition(" Long   con.fetch.max.wait.ms                  500  ");
        this.addDefinition(" Int out.poll.duration.ms  1800  ");
        this.addDefinition(" Int out.worker.count         1  ");
    }

    public int getIntParam(String key, int valueOnAbsent) {
        ParameterDefinition parameterDefinition = this.parameterDefinitionMap.get(key);
        if (parameterDefinition == null) {
            return valueOnAbsent;
        }
        return parameterDefinition.validator.getIntValue(parameterDefinition.defaultValue, "" + valueOnAbsent);
    }

    public void addDefinition(String definitionStr) {
        String trimmedDefStr = definitionStr.trim();
        int idx1 = trimmedDefStr.indexOf(32);
        if (idx1 < 0) {
            throw new RuntimeException("4HmXzZgRRT :: Illegal definition str = [" + definitionStr + "]");
        }
        String validatorStr = trimmedDefStr.substring(0, idx1);
        String restStr2 = trimmedDefStr.substring(idx1 + 1).trim();
        int idx2 = restStr2.indexOf(32);
        if (idx2 < 0) {
            throw new RuntimeException("32s3t7NqhS :: Illegal definition str = [" + definitionStr + "]");
        }
        String parameterName = restStr2.substring(0, idx2);
        String defaultValue = restStr2.substring(idx2 + 1).trim();
        ParameterValueValidator validator = Objects.requireNonNull(validatorMap.get(validatorStr), "29N38wqS98 :: validatorStr = [" + validatorStr + "]");
        ParameterDefinition definition = new ParameterDefinition(parameterName, defaultValue, validator);
        this.parameterDefinitionList.add(definition);
        this.parameterDefinitionMap.put(definition.parameterName, definition);
    }

    public List<ParameterDefinition> parameterDefinitionList() {
        return this.parameterDefinitionList;
    }

    public ParameterDefinition getDefinition(String parameterName) {
        Objects.requireNonNull(parameterName);
        ParameterDefinition pd = this.parameterDefinitionMap.get(parameterName);
        if (pd != null) {
            return pd;
        }
        return DEFAULT_PARAMETER_DEFINITION;
    }

    public List<String> toConfigFileLines() {
        return this.parameterDefinitionList.stream().map(ParameterDefinition::toConfigFileLine).collect(Collectors.toList());
    }

    static {
        HashMap<String, ParameterValueValidator> vMap = new HashMap<String, ParameterValueValidator>();
        vMap.put("Long", new ParameterValueValidatorLong());
        vMap.put("Int", new ParameterValueValidatorInt());
        vMap.put("Str", new ParameterValueValidatorStr());
        validatorMap = Collections.unmodifiableMap(vMap);
        DEFAULT_PARAMETER_DEFINITION = new ParameterDefinition(null, "", new ParameterValueValidatorStr());
    }
}

