/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.config;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.config.AbstractTextLinesConfig;
import kz.greetgo.kafka.consumer.config.ConsumerConfigDefaultsAccess;
import kz.greetgo.kafka.consumer.config.ConsumerReactorConfig;
import kz.greetgo.kafka.consumer.config.ControllerWorkerCountConfig;
import kz.greetgo.kafka.consumer.config.FolderConsumerParamsConfig;
import kz.greetgo.kafka.core.config.EventConfigFileFactory;
import kz.greetgo.kafka.util.Handler;
import kz.greetgo.kafka.util.KafkaStrUtil;
import kz.greetgo.kafka.util.Listener;

public class ConsumerReactorConfigFactory
implements AutoCloseable {
    private final Object sync = new Object();
    private final EventConfigFileFactory configFactory;
    private final ConsumerConfigDefaultsAccess defaults;
    private final String consumerParamsName;
    private final String profileConfigPrefix;
    private final ConcurrentHashMap<Object, ConsumerReactorConfig> consumerConfigMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<PathProfileKey, FolderConsumerParamsConfig> folderConsumerParamsConfigMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<PathProfileKey, ControllerWorkerCountConfig> controllerWorkerCountConfigMap = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    private ConsumerReactorConfigFactory(EventConfigFileFactory configFactory, ConsumerConfigDefaultsAccess defaults, String consumerParamsName, String profileConfigPrefix) {
        this.configFactory = configFactory;
        this.defaults = defaults;
        this.consumerParamsName = consumerParamsName;
        this.profileConfigPrefix = profileConfigPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerReactorConfig getConsumerConfig(ConsumerDefinition consumerDefinition) {
        ConsumerReactorConfig consumerConfig = this.consumerConfigMap.get(consumerDefinition.id());
        if (consumerConfig != null) {
            return consumerConfig;
        }
        Object object = this.sync;
        synchronized (object) {
            ConsumerReactorConfig consumerConfig2 = this.consumerConfigMap.get(consumerDefinition.id());
            if (consumerConfig2 != null) {
                return consumerConfig2;
            }
            consumerConfig2 = this.createConsumerConfig(consumerDefinition);
            this.consumerConfigMap.put(consumerDefinition.id(), consumerConfig2);
            return consumerConfig2;
        }
    }

    private ConsumerReactorConfig createConsumerConfig(final ConsumerDefinition consumerDefinition) {
        return new ConsumerReactorConfig(){

            @Override
            public Listener onChangeParams(Handler handler, Profile profile) {
                return ConsumerReactorConfigFactory.this.getFolderConsumerParamsConfig(consumerDefinition, profile).addChangeHandler(handler);
            }

            @Override
            public Listener onChangeWorkerCount(Handler handler, Profile profile) {
                return ConsumerReactorConfigFactory.this.getControllerWorkerCountConfig(consumerDefinition, profile).addChangeHandler(handler);
            }

            @Override
            public Map<String, String> getConfigMap(Profile profile) {
                return ConsumerReactorConfigFactory.this.getFolderConsumerParamsConfig(consumerDefinition, profile).getConfigMap();
            }

            @Override
            public int getWorkerCount(Profile profile) {
                return ConsumerReactorConfigFactory.this.getControllerWorkerCountConfig(consumerDefinition, profile).getWorkerCount(consumerDefinition.getName());
            }

            @Override
            public Duration getPollDuration(Profile profile) {
                return ConsumerReactorConfigFactory.this.getFolderConsumerParamsConfig(consumerDefinition, profile).pollDuration();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderConsumerParamsConfig getFolderConsumerParamsConfig(ConsumerDefinition consumerDefinition, Profile profile) {
        String consumerParamsName = this.consumerParamsName;
        String folderPath = consumerDefinition.getFolderPath();
        String configPath = KafkaStrUtil.concatPath(folderPath, profile.withPrefix(this.profileConfigPrefix), consumerParamsName);
        PathProfileKey key = new PathProfileKey(configPath, profile);
        FolderConsumerParamsConfig x = this.folderConsumerParamsConfigMap.get(key);
        if (x != null) {
            return x;
        }
        Object object = this.sync;
        synchronized (object) {
            FolderConsumerParamsConfig x2 = this.folderConsumerParamsConfigMap.get(key);
            if (x2 != null) {
                return x2;
            }
            x2 = new FolderConsumerParamsConfig(this.configFactory.createEventConfigFile(configPath), () -> this.defaults.get(profile));
            this.folderConsumerParamsConfigMap.put(key, x2);
            return x2;
        }
    }

    private ControllerWorkerCountConfig getControllerWorkerCountConfig(ConsumerDefinition consumerDefinition, Profile profile) {
        ControllerWorkerCountConfig c = this.extractControllerWorkerCountConfig(consumerDefinition, profile);
        c.register(consumerDefinition.getName(), consumerDefinition.getDescription());
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerWorkerCountConfig extractControllerWorkerCountConfig(ConsumerDefinition consumerDefinition, Profile profile) {
        String workerCountFileName = consumerDefinition.workerCountFileName();
        String folderPath = consumerDefinition.getFolderPath();
        String configPath = KafkaStrUtil.concatPath(folderPath, profile.withPrefix(this.profileConfigPrefix), workerCountFileName);
        PathProfileKey key = new PathProfileKey(configPath, profile);
        ControllerWorkerCountConfig c = this.controllerWorkerCountConfigMap.get(key);
        if (c != null) {
            return c;
        }
        Object object = this.sync;
        synchronized (object) {
            ControllerWorkerCountConfig c2 = this.controllerWorkerCountConfigMap.get(key);
            if (c2 != null) {
                return c2;
            }
            c2 = new ControllerWorkerCountConfig(this.configFactory.createEventConfigFile(configPath), () -> this.defaults.get(profile));
            this.controllerWorkerCountConfigMap.put(key, c2);
            return c2;
        }
    }

    @Override
    public void close() {
        boolean hasRemoves = true;
        while (hasRemoves) {
            AbstractTextLinesConfig removed;
            hasRemoves = false;
            PathProfileKey key = this.folderConsumerParamsConfigMap.keySet().stream().findAny().orElse(null);
            if (key != null) {
                hasRemoves = true;
                removed = this.folderConsumerParamsConfigMap.remove(key);
                if (removed != null) {
                    removed.close();
                }
            }
            if ((key = (PathProfileKey)this.controllerWorkerCountConfigMap.keySet().stream().findAny().orElse(null)) == null) continue;
            hasRemoves = true;
            removed = this.controllerWorkerCountConfigMap.remove(key);
            if (removed == null) continue;
            removed.close();
        }
    }

    private static final class PathProfileKey {
        public final String path;
        public final Profile profile;

        private PathProfileKey(String path, Profile profile) {
            this.path = Objects.requireNonNull(path, "p5Pj2Y9Ur2");
            this.profile = Objects.requireNonNull(profile, "TuyBBvm6H3");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathProfileKey that = (PathProfileKey)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.profile, that.profile);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.profile);
        }
    }

    public static class Builder {
        EventConfigFileFactory configFactory;
        ConsumerConfigDefaultsAccess defaults;
        String consumerParamsName = "params.config";
        String profileConfigPrefix = "external/";

        public Builder configFactory(EventConfigFileFactory configFactory) {
            this.configFactory = Objects.requireNonNull(configFactory);
            return this;
        }

        public Builder defaults(ConsumerConfigDefaultsAccess defaults) {
            this.defaults = Objects.requireNonNull(defaults);
            return this;
        }

        public Builder consumerParamsName(String consumerParamsName) {
            this.consumerParamsName = Objects.requireNonNull(consumerParamsName);
            return this;
        }

        public Builder profileConfigPrefix(String profileConfigPrefix) {
            this.profileConfigPrefix = profileConfigPrefix;
            return this;
        }

        private Builder() {
        }

        public ConsumerReactorConfigFactory build() {
            return new ConsumerReactorConfigFactory(Objects.requireNonNull(this.configFactory), Objects.requireNonNull(this.defaults), Objects.requireNonNull(this.consumerParamsName), this.profileConfigPrefix);
        }
    }
}

