/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.consumer.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kz.greetgo.kafka.consumer.config.AbstractTextLinesConfig;
import kz.greetgo.kafka.consumer.config.ConsumerConfigDefaults;
import kz.greetgo.kafka.consumer.config.WorkCountRecord;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.util.StreamUtil;

public class ControllerWorkerCountConfig
extends AbstractTextLinesConfig
implements AutoCloseable {
    private final Supplier<ConsumerConfigDefaults> defaults;
    private final List<WorkCountRecord> registeredRecords = new ArrayList<WorkCountRecord>();

    public ControllerWorkerCountConfig(EventConfigFile configFile, Supplier<ConsumerConfigDefaults> defaults) {
        super(configFile);
        this.defaults = defaults;
    }

    public int getWorkerCount(String methodName) {
        String value = this.readData(methodName).get(methodName);
        try {
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    public synchronized void register(String methodName, String description) {
        if (this.registeredRecords.stream().noneMatch(r -> Objects.equals(methodName, r.methodName))) {
            this.registeredRecords.add(new WorkCountRecord(methodName, description, this.getDefaultWorkCount()));
        }
    }

    private int getDefaultWorkCount() {
        return this.defaults.get().getIntParam("out.worker.count", 1);
    }

    @Override
    protected synchronized List<String> createDefaultLines() {
        return this.registeredRecords.stream().flatMap(ControllerWorkerCountConfig::convertRecordToLines).collect(Collectors.toList());
    }

    private static Stream<String> convertRecordToLines(WorkCountRecord record) {
        return StreamUtil.concat(Stream.of(""), record.descriptionAsLinesStream().map(x -> "# " + x), Stream.of(record.methodName + " = " + record.defaultValue));
    }
}

