/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerActivateFilter;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerDefinitionCustom;
import kz.greetgo.kafka.consumer.ConsumerDefinitionCustomBuilder;
import kz.greetgo.kafka.consumer.ConsumerDefinitionExtractor;
import kz.greetgo.kafka.consumer.ConsumerDefinitionOnController;
import kz.greetgo.kafka.consumer.config.ConsumerConnectParams;
import kz.greetgo.kafka.consumer.config.ConsumerConnectSetter;
import kz.greetgo.kafka.core.BoxInterceptor;
import kz.greetgo.kafka.core.ConsumerDefinitionValidator;
import kz.greetgo.kafka.core.KafkaReactor;
import kz.greetgo.kafka.core.ProducerBytesInterceptor;
import kz.greetgo.kafka.core.ProducerStrInterceptor;
import kz.greetgo.kafka.core.ProducerSynchronizer;
import kz.greetgo.kafka.core.consumer_filter.ConsumerFilterManager;
import kz.greetgo.kafka.core.consumer_filter.ConsumerFilterRegistrar;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.core.logger.LoggerExternal;
import kz.greetgo.kafka.producer.BoxRecord;
import kz.greetgo.kafka.producer.ProducerFacade;
import kz.greetgo.kafka.producer.ProducerFacadeBox;
import kz.greetgo.kafka.producer.ProducerFacadeBytes;
import kz.greetgo.kafka.producer.ProducerFacadeStr;
import kz.greetgo.kafka.producer.ProducerSource;
import kz.greetgo.kafka.producer.RecordBytes;
import kz.greetgo.kafka.producer.RecordStr;
import kz.greetgo.kafka.producer.config.ProducerConnectParams;
import kz.greetgo.kafka.producer.config.ProducerConnectSetter;
import kz.greetgo.strconverter.StrConverter;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class KafkaReactorAbstract
implements KafkaReactor {
    Supplier<String> authorSupplier;
    Supplier<String> consumerHostId;
    Supplier<String> topicPrefix = () -> null;
    Supplier<String> bootstrapServers;
    protected ConsumerConnectSetter consumerConnectSetter = new ConsumerConnectSetter(){

        @Override
        public void setConnect(Map<String, Object> targetConfigMap, ConsumerConnectParams params) {
            targetConfigMap.put("bootstrap.servers", KafkaReactorAbstract.this.bootstrapServers.get());
        }
    };
    protected ProducerConnectSetter producerConnectSetter = new ProducerConnectSetter(){

        @Override
        public void setConnect(Map<String, Object> targetConfigMap, ProducerConnectParams params) {
            targetConfigMap.put("bootstrap.servers", KafkaReactorAbstract.this.bootstrapServers.get());
        }
    };
    Function<Object, String> controllerToWorkerCountFileName = c -> c.getClass().getSimpleName() + ".workerCount";
    protected final Logger logger;
    protected final ProducerSynchronizer producerSynchronizer;
    final List<ConsumerDefinitionValidator> consumerDefinitionValidatorList = new ArrayList<ConsumerDefinitionValidator>();
    private final List<ConsumerDefinitionCustomBuilder> additionalDcBuilderList = new ArrayList<ConsumerDefinitionCustomBuilder>();
    List<Object> controllerList;
    Supplier<StrConverter> strConverter;
    private final ConsumerFilterManager consumerFilterManager = new ConsumerFilterManager();
    protected List<ConsumerDefinition> consumerDefinitionList;
    private final BoxInterceptor boxInterceptor = this::afterKafkaSent;
    private final ProducerStrInterceptor producerStrInterceptor = this::afterKafkaSentStr;
    private final ProducerBytesInterceptor producerBytesInterceptor = this::afterKafkaSentBytes;

    @Override
    public ConsumerFilterRegistrar consumerFilterRegistrar() {
        return this.consumerFilterManager;
    }

    @Override
    public void addConsumerDefinitionCustomBuilder(ConsumerDefinitionCustomBuilder consumerDefinitionCustomBuilder) {
        this.additionalDcBuilderList.add(consumerDefinitionCustomBuilder);
    }

    protected KafkaReactorAbstract(Logger logger) {
        this.logger = logger;
        this.producerSynchronizer = new ProducerSynchronizer(logger);
    }

    @Override
    public LoggerExternal logger() {
        return this.logger;
    }

    protected abstract ProducerSource getProducerSource();

    @Override
    public ProducerSynchronizer producerSynchronizer() {
        return this.producerSynchronizer;
    }

    protected abstract void afterKafkaSent(BoxRecord var1);

    protected void afterKafkaSentStr(RecordStr recordStr) {
    }

    protected void afterKafkaSentBytes(RecordBytes recordStr) {
    }

    @Override
    public ProducerFacade<Object> createProducer(String producerName) {
        return ProducerFacadeBox.create(producerName, this.getProducerSource(), this.producerSynchronizer, () -> this.topicPrefix.get(), this.boxInterceptor);
    }

    @Override
    public ProducerFacade<String> createProducerStr(String producerName) {
        return ProducerFacadeStr.create(producerName, this.getProducerSource(), this.producerSynchronizer, () -> this.topicPrefix.get(), this.producerStrInterceptor);
    }

    @Override
    public ProducerFacade<byte[]> createProducerBytes(String producerName) {
        return ProducerFacadeBytes.create(producerName, this.getProducerSource(), this.producerSynchronizer, () -> this.topicPrefix.get(), this.producerBytesInterceptor);
    }

    protected void accumulateConsumerDefinitionList() {
        this.consumerDefinitionList = new ArrayList<ConsumerDefinition>();
        ConsumerDefinitionExtractor cde = new ConsumerDefinitionExtractor(this.logger, () -> this.topicPrefix.get(), this.controllerToWorkerCountFileName, this.consumerHostId, this.consumerFilterManager);
        ConsumerActivateFilter caf = this.getConsumerActivateFilter();
        for (Object controller : this.controllerList) {
            for (ConsumerDefinitionOnController def : cde.extract(controller)) {
                if (!caf.activateFromController(def)) continue;
                this.consumerDefinitionList.add(def);
            }
        }
        for (ConsumerDefinitionCustomBuilder consumerDcBuilder : this.additionalDcBuilderList) {
            ConsumerDefinitionCustom def = this.prepareConsumerDefinition(consumerDcBuilder).build();
            if (!caf.activateCustom(def)) continue;
            this.consumerDefinitionList.add(def);
        }
        for (ConsumerDefinitionValidator cdv : this.consumerDefinitionValidatorList) {
            this.consumerDefinitionList.forEach(cdv::validate);
        }
    }

    protected abstract ConsumerActivateFilter getConsumerActivateFilter();

    protected ConsumerDefinitionCustomBuilder prepareConsumerDefinition(@NonNull ConsumerDefinitionCustomBuilder consumerDcBuilder) {
        return consumerDcBuilder.logger(this.logger).topicPrefix(this.topicPrefix).consumerFilter(this.consumerFilterManager);
    }
}

