/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerActivateFilter;
import kz.greetgo.kafka.consumer.ConsumerDefinitionOnController;
import kz.greetgo.kafka.consumer.config.ConsumerConnectSetter;
import kz.greetgo.kafka.consumer.config.ConsumerReactorConfigFactory;
import kz.greetgo.kafka.core.ConsumerDefinitionValidator;
import kz.greetgo.kafka.core.KafkaReactor;
import kz.greetgo.kafka.core.KafkaReactorImpl;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.producer.config.ProducerConnectSetter;
import kz.greetgo.kafka.producer.config.ProducerReactorConfigFactory;
import kz.greetgo.kafka.util.Fnn;
import kz.greetgo.strconverter.StrConverter;

public class KafkaReactorBuilder {
    private final Logger logger = new Logger();
    private final List<Object> controllerList = new ArrayList<Object>();
    private Supplier<StrConverter> strConverter;
    private Supplier<String> bootstrapServers;
    private ConsumerConnectSetter consumerConnectSetter;
    private ProducerConnectSetter producerConnectSetter;
    private Supplier<String> authorSupplier;
    private Supplier<String> consumerHostId = () -> null;
    private Supplier<String> topicPrefix = () -> null;
    private Supplier<String> consumerThreadPrefix = () -> "kafka-consumer-";
    private ConsumerActivateFilter consumerActivateFilter;
    private Function<Object, String> controllerToWorkerCountFileName = controller -> controller.getClass().getSimpleName() + ".workerCount";
    private ConsumerReactorConfigFactory consumerConfigFactory;
    private ConsumerReactorConfigFactory dynamicConsumerConfigFactory;
    private ProducerReactorConfigFactory producerConfigFactory;
    private LongSupplier refreshTopicListMillis = () -> 15000L;
    private final List<ConsumerDefinitionValidator> consumerDefinitionValidatorList = new ArrayList<ConsumerDefinitionValidator>();

    KafkaReactorBuilder() {
    }

    public KafkaReactorBuilder onLogger(Consumer<Logger> loggerConsumer) {
        loggerConsumer.accept(this.logger);
        return this;
    }

    public KafkaReactorBuilder loggerErrorSkipper(Predicate<Throwable> errorSkipper) {
        this.logger.setErrorSkipper(errorSkipper);
        return this;
    }

    public KafkaReactorBuilder addController(Object controller) {
        this.controllerList.add(Objects.requireNonNull(controller));
        return this;
    }

    public KafkaReactorBuilder consumerActivateFilter(ConsumerActivateFilter consumerActivateFilter) {
        this.consumerActivateFilter = consumerActivateFilter;
        return this;
    }

    public KafkaReactorBuilder refreshTopicListMillis(LongSupplier refreshTopicListMillis) {
        this.refreshTopicListMillis = Objects.requireNonNull(refreshTopicListMillis);
        return this;
    }

    public KafkaReactorBuilder addControllers(Collection<?> controllers) {
        if (controllers != null) {
            controllers.forEach(this::addController);
        }
        return this;
    }

    public KafkaReactorBuilder strConverter(Supplier<StrConverter> strConverter) {
        this.strConverter = Objects.requireNonNull(strConverter);
        return this;
    }

    public KafkaReactorBuilder consumerHostId(Supplier<String> consumerHostId) {
        this.consumerHostId = Objects.requireNonNull(consumerHostId);
        return this;
    }

    public KafkaReactorBuilder consumerConfigFactory(ConsumerReactorConfigFactory consumerConfigFactory) {
        this.consumerConfigFactory = consumerConfigFactory;
        return this;
    }

    public KafkaReactorBuilder dynamicConsumerConfigFactory(ConsumerReactorConfigFactory consumerConfigFactory) {
        this.dynamicConsumerConfigFactory = consumerConfigFactory;
        return this;
    }

    public KafkaReactorBuilder producerConfigFactory(ProducerReactorConfigFactory producerConfigFactory) {
        this.producerConfigFactory = producerConfigFactory;
        return this;
    }

    public KafkaReactorBuilder bootstrapServers(Supplier<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaReactorBuilder consumerConnectSetter(ConsumerConnectSetter consumerConnectSetter) {
        this.consumerConnectSetter = consumerConnectSetter;
        return this;
    }

    public KafkaReactorBuilder producerConnectSetter(ProducerConnectSetter producerConnectSetter) {
        this.producerConnectSetter = producerConnectSetter;
        return this;
    }

    public KafkaReactorBuilder authorSupplier(Supplier<String> authorSupplier) {
        this.authorSupplier = authorSupplier;
        return this;
    }

    public KafkaReactorBuilder consumerDefinitionValidator(ConsumerDefinitionValidator consumerDefinitionValidator) {
        this.consumerDefinitionValidatorList.add(consumerDefinitionValidator);
        return this;
    }

    public KafkaReactorBuilder makeConsumerDescriptionMandatory() {
        this.consumerDefinitionValidatorList.add(consumerDefinition -> {
            ConsumerDefinitionOnController x;
            if (consumerDefinition instanceof ConsumerDefinitionOnController && (x = (ConsumerDefinitionOnController)consumerDefinition).getDescription() == null) {
                throw new RuntimeException("EoH1cZzmA8 :: No description in consumer " + x.logDisplay());
            }
        });
        return this;
    }

    public KafkaReactorBuilder topicPrefix(Supplier<String> topicPrefix) {
        this.topicPrefix = topicPrefix;
        return this;
    }

    public KafkaReactorBuilder consumerThreadPrefix(Supplier<String> consumerThreadPrefix) {
        this.consumerThreadPrefix = consumerThreadPrefix;
        return this;
    }

    public KafkaReactorBuilder controllerToWorkerCountFileName(Function<Object, String> controllerToWorkerCountFileName) {
        this.controllerToWorkerCountFileName = Objects.requireNonNull(controllerToWorkerCountFileName);
        return this;
    }

    public KafkaReactor build() {
        KafkaReactorImpl reactor = new KafkaReactorImpl(this.logger);
        if (this.bootstrapServers == null && this.consumerConnectSetter == null) {
            throw new RuntimeException("MqLUt04o9a :: You MUST defined one of `bootstrapServers` OR `consumerConnectSetter`");
        }
        if (this.bootstrapServers == null && this.producerConnectSetter == null) {
            throw new RuntimeException("8VT3qv19ev :: You MUST defined one of `bootstrapServers` OR `producerConnectSetter`");
        }
        if (this.bootstrapServers != null) {
            reactor.bootstrapServers = this.bootstrapServers;
        }
        if (this.consumerConnectSetter != null) {
            reactor.consumerConnectSetter = this.consumerConnectSetter;
        }
        if (this.producerConnectSetter != null) {
            reactor.producerConnectSetter = this.producerConnectSetter;
        }
        reactor.strConverter = Objects.requireNonNull(this.strConverter);
        reactor.consumerHostId = Objects.requireNonNull(this.consumerHostId);
        reactor.topicPrefix = Objects.requireNonNull(this.topicPrefix);
        reactor.controllerList = Objects.requireNonNull(this.controllerList);
        reactor.consumerConfigFactory = Objects.requireNonNull(this.consumerConfigFactory);
        reactor.dynamicConsumerConfigFactory = Objects.requireNonNull(Fnn.fnn(this.dynamicConsumerConfigFactory, this.consumerConfigFactory));
        reactor.producerConfigFactory = Objects.requireNonNull(this.producerConfigFactory);
        reactor.authorSupplier = Objects.requireNonNull(this.authorSupplier);
        reactor.consumerThreadPrefix = Objects.requireNonNull(this.consumerThreadPrefix);
        reactor.refreshTopicListMillis = Objects.requireNonNull(this.refreshTopicListMillis);
        reactor.consumerActivateFilter = this.consumerActivateFilter;
        reactor.consumerDefinitionValidatorList.addAll(this.consumerDefinitionValidatorList);
        reactor.controllerToWorkerCountFileName = this.controllerToWorkerCountFileName;
        return reactor;
    }
}

