/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kz.greetgo.kafka.core.KafkaSimulator;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.core.logger.LoggerExternal;
import kz.greetgo.strconverter.StrConverter;
import org.apache.kafka.common.Cluster;

public class KafkaSimulatorBuilder {
    private final Logger logger = new Logger();
    private final List<Object> controllerList = new ArrayList<Object>();
    private Supplier<StrConverter> strConverter;
    private Supplier<String> authorSupplier;
    private Supplier<String> consumerHostId = () -> null;
    private Supplier<Cluster> clusterSupplier = Cluster::empty;

    KafkaSimulatorBuilder() {
    }

    public KafkaSimulatorBuilder onLogger(Consumer<LoggerExternal> loggerConsumer) {
        loggerConsumer.accept(this.logger);
        return this;
    }

    public KafkaSimulatorBuilder addController(Object controller) {
        this.controllerList.add(Objects.requireNonNull(controller));
        return this;
    }

    public KafkaSimulatorBuilder addControllers(List<?> controllerList) {
        if (controllerList != null) {
            controllerList.forEach(this::addController);
        }
        return this;
    }

    public KafkaSimulatorBuilder strConverter(Supplier<StrConverter> strConverter) {
        this.strConverter = Objects.requireNonNull(strConverter);
        return this;
    }

    public KafkaSimulatorBuilder consumerHostId(Supplier<String> consumerHostId) {
        this.consumerHostId = Objects.requireNonNull(consumerHostId);
        return this;
    }

    public KafkaSimulatorBuilder authorSupplier(Supplier<String> authorSupplier) {
        this.authorSupplier = Objects.requireNonNull(authorSupplier);
        return this;
    }

    public KafkaSimulatorBuilder clusterSupplier(Supplier<Cluster> clusterSupplier) {
        this.clusterSupplier = Objects.requireNonNull(clusterSupplier);
        return this;
    }

    public KafkaSimulatorBuilder loggerErrorSkipper(Predicate<Throwable> errorSkipper) {
        this.logger.setErrorSkipper(errorSkipper);
        return this;
    }

    public KafkaSimulator build() {
        KafkaSimulator simulator = new KafkaSimulator(this.logger);
        simulator.strConverter = Objects.requireNonNull(this.strConverter);
        simulator.consumerHostId = Objects.requireNonNull(this.consumerHostId);
        simulator.controllerList = Objects.requireNonNull(this.controllerList);
        simulator.authorSupplier = Objects.requireNonNull(this.authorSupplier);
        simulator.clusterSupplier = Objects.requireNonNull(this.clusterSupplier);
        return simulator;
    }
}

