/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.List;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;

public class MockProducerHolder<ValueType> {
    private final String producerName;
    private final ByteArraySerializer keySerializer;
    private final Serializer<ValueType> valueSerializer;
    private final Cluster cluster;
    private final Partitioner partitioner;
    private final MockProducer<byte[], ValueType> producer;

    public MockProducerHolder(String producerName, ByteArraySerializer keySerializer, Serializer<ValueType> valueSerializer, Cluster cluster) {
        this.producerName = producerName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.cluster = cluster == null ? Cluster.empty() : cluster;
        this.partitioner = new DefaultPartitioner();
        this.producer = new MockProducer(this.cluster, true, this.partitioner, (Serializer)keySerializer, valueSerializer);
    }

    public String getProducerName() {
        return this.producerName;
    }

    public MockProducer<byte[], ValueType> getProducer() {
        return this.producer;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public TopicPartition topicPartition(ProducerRecord<byte[], ValueType> record) {
        int partition = 0;
        if (!this.cluster.partitionsForTopic(record.topic()).isEmpty()) {
            partition = this.partition(record, this.cluster);
        }
        return new TopicPartition(record.topic(), partition);
    }

    private int partition(ProducerRecord<byte[], ValueType> record, Cluster cluster) {
        Integer partition = record.partition();
        String topic = record.topic();
        if (partition != null) {
            List partitions = cluster.partitionsForTopic(topic);
            int numPartitions = partitions.size();
            if (partition < 0 || partition >= numPartitions) {
                throw new IllegalArgumentException("Ly889OE758 :: Invalid partition given with record: " + partition + " is not in the range [0..." + numPartitions + "].");
            }
            return partition;
        }
        byte[] keyBytes = this.keySerializer.serialize(topic, record.headers(), (Object)((byte[])record.key()));
        byte[] valueBytes = this.valueSerializer.serialize(topic, record.headers(), record.value());
        return this.partitioner.partition(topic, record.key(), keyBytes, record.value(), valueBytes, cluster);
    }
}

