/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kz.greetgo.kafka.core.ConsumerPortionInvoking;
import kz.greetgo.kafka.core.logger.Logger;
import kz.greetgo.kafka.producer.KafkaFuture;

public class ProducerSynchronizer {
    private final Logger logger;
    private final ThreadLocal<ConsumerContext> consumerContextHolder = InheritableThreadLocal.withInitial(() -> null);

    public ProducerSynchronizer(Logger logger) {
        this.logger = logger;
    }

    public ConsumerPortionInvoking startPortionInvoking() {
        ConsumerContext consumerContext = new ConsumerContext();
        this.consumerContextHolder.set(consumerContext);
        return () -> {
            consumerContext.close();
            this.consumerContextHolder.set(null);
        };
    }

    public void acceptKafkaFuture(KafkaFuture kafkaFuture) {
        ConsumerContext consumerContext = this.consumerContextHolder.get();
        if (consumerContext == null) {
            kafkaFuture.awaitAndGet();
            return;
        }
        consumerContext.append(kafkaFuture);
    }

    private class ConsumerContext {
        private final Queue<KafkaFuture> futureList = new ConcurrentLinkedQueue<KafkaFuture>();

        private ConsumerContext() {
        }

        void close() {
            try {
                for (KafkaFuture kafkaFuture : this.futureList) {
                    kafkaFuture.awaitAndGet(false);
                }
            }
            catch (Exception exception) {
                ProducerSynchronizer.this.logger.logProducerAwaitAndGetError("JO2wqXe3gh", exception);
            }
        }

        public void append(KafkaFuture kafkaFuture) {
            this.futureList.add(kafkaFuture);
        }
    }
}

