/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventConfigFileFactory;
import kz.greetgo.kafka.core.config.EventConfigFileFromStorage;
import kz.greetgo.kafka.core.config.EventConfigStorage;

public class EventConfigFileFactoryOverStorage
implements EventConfigFileFactory {
    private final EventConfigStorage storage;
    private final String topPath;

    public EventConfigFileFactoryOverStorage(EventConfigStorage storage) {
        this(storage, null);
    }

    public EventConfigFileFactoryOverStorage(EventConfigStorage storage, String topPath) {
        this.storage = storage;
        this.topPath = topPath;
    }

    @Override
    public EventConfigFile createEventConfigFile(String path) {
        return new EventConfigFileFromStorage(this.connect(path), this.storage);
    }

    private String connect(String path) {
        if (this.topPath == null) {
            return path;
        }
        if (path == null) {
            return this.topPath;
        }
        String left = this.topPath;
        while (left.endsWith("/")) {
            left = left.substring(0, left.length() - 1);
        }
        String right = path;
        while (right.startsWith("/")) {
            right = right.substring(1);
        }
        return left + "/" + right;
    }

    @Override
    public EventConfigFileFactory cd(String subPath) {
        return new EventConfigFileFactoryOverStorage(this.storage, this.connect(subPath));
    }

    @Override
    public void close() {
        this.storage.close();
    }
}

