/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorageAbstract;

public class EventConfigStorageFs
extends EventConfigStorageAbstract {
    private final Path rootDir;
    private final ConcurrentHashMap<Path, LookingFile> lookingForPaths = new ConcurrentHashMap();

    private EventConfigStorageFs(Path rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public Optional<Date> createdAt(String path) {
        try {
            Path fullPath = this.rootDir.resolve(path);
            BasicFileAttributes attrs = Files.readAttributes(fullPath, BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attrs.creationTime();
            return Optional.of(new Date(fileTime.toMillis()));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Date> readLastModifiedAt(Path fullPath) {
        try {
            BasicFileAttributes attrs = Files.readAttributes(fullPath, BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attrs.lastModifiedTime();
            return Optional.of(new Date(fileTime.toMillis()));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Date> lastModifiedAt(String path) {
        return this.readLastModifiedAt(this.rootDir.resolve(path));
    }

    private byte[] readContentOrNull(Path fullPath) {
        try {
            return Files.readAllBytes(fullPath);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] readContent(String path) {
        Path fullPath = this.rootDir.resolve(path);
        byte[] content = this.readContentOrNull(fullPath);
        LookingFile lookingFile = this.lookingForPaths.get(fullPath);
        if (lookingFile != null) {
            lookingFile.content.set(content);
            lookingFile.lastModified.set(this.readLastModifiedAt(fullPath).orElse(null));
        }
        return content;
    }

    @Override
    public void writeContent(String path, byte[] content) {
        Path fullPath = this.rootDir.resolve(path);
        if (content == null) {
            LookingFile lookingFile;
            if (Files.exists(fullPath, new LinkOption[0])) {
                try {
                    Files.delete(fullPath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((lookingFile = this.lookingForPaths.get(fullPath)) != null) {
                lookingFile.content.set(null);
                lookingFile.lastModified.set(null);
            }
            return;
        }
        fullPath.toFile().getParentFile().mkdirs();
        try {
            Files.write(fullPath, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LookingFile lookingFile = this.lookingForPaths.get(fullPath);
        if (lookingFile != null) {
            lookingFile.content.set(content);
            lookingFile.lastModified.set(this.readLastModifiedAt(fullPath).orElse(null));
        }
    }

    @Override
    public void ensureLookingFor(String path) {
        Path rootPath = this.rootDir.resolve(path);
        this.lookingForPaths.putIfAbsent(rootPath, new LookingFile(path, rootPath));
    }

    public void ping() {
        this.lookingForPaths.values().forEach(LookingFile::ping);
    }

    private class LookingFile {
        final String path;
        final Path fullPath;
        final AtomicReference<byte[]> content = new AtomicReference<Object>(null);
        final AtomicReference<Date> lastModified = new AtomicReference<Object>(null);

        private LookingFile(String path, Path fullPath) {
            this.path = path;
            this.fullPath = fullPath;
            this.content.set(EventConfigStorageFs.this.readContentOrNull(fullPath));
            this.lastModified.set(EventConfigStorageFs.this.readLastModifiedAt(fullPath).orElse(null));
        }

        public void ping() {
            byte[] contentNew;
            Date lastModifiedNew = EventConfigStorageFs.this.readLastModifiedAt(this.fullPath).orElse(null);
            Date lastModifiedOld = this.lastModified.get();
            this.lastModified.set(lastModifiedNew);
            if (lastModifiedNew == null && lastModifiedOld == null) {
                return;
            }
            if (lastModifiedNew == null) {
                EventConfigStorageFs.this.fireConfigEventHandler(this.path, ConfigEventType.DELETE);
                return;
            }
            if (lastModifiedOld == null) {
                EventConfigStorageFs.this.fireConfigEventHandler(this.path, ConfigEventType.CREATE);
                return;
            }
            byte[] contentOld = this.content.get();
            if (Arrays.equals(contentOld, contentNew = EventConfigStorageFs.this.readContentOrNull(this.fullPath))) {
                return;
            }
            this.content.set(contentNew);
            EventConfigStorageFs.this.fireConfigEventHandler(this.path, ConfigEventType.UPDATE);
        }
    }

    public static class Builder {
        private Path rootDir;

        public Builder rootDir(Path rootDir) {
            this.rootDir = Objects.requireNonNull(rootDir);
            return this;
        }

        public Builder rootDir(String rootDirPath) {
            this.rootDir = Paths.get(Objects.requireNonNull(rootDirPath), new String[0]);
            return this;
        }

        public EventConfigStorageFs build() {
            return new EventConfigStorageFs(Objects.requireNonNull(this.rootDir, "rootDir"));
        }
    }
}

