/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorageAbstract;
import kz.greetgo.kafka.util.KafkaStrUtil;

public class EventConfigStorageInMem
extends EventConfigStorageAbstract {
    private final ConcurrentHashMap<String, FileRecord> data = new ConcurrentHashMap();
    private final Map<String, FileRecord> state = new HashMap<String, FileRecord>();
    private final ConcurrentHashMap<String, Boolean> lookingForPaths = new ConcurrentHashMap();

    @Override
    public byte[] readContent(String path) {
        return Optional.ofNullable(this.data.get(path)).map(a -> a.data).orElse(null);
    }

    public List<String> readLines(String path) {
        return KafkaStrUtil.bytesToLines(this.readContent(path));
    }

    @Override
    public void writeContent(String path, byte[] content) {
        if (content == null) {
            this.data.remove(path);
        } else {
            this.data.compute(path, (path1, fileRecord) -> fileRecord == null ? FileRecord.create(content) : fileRecord.modify(content));
        }
    }

    @Override
    public Optional<Date> createdAt(String path) {
        return Optional.ofNullable(this.data.get(path)).map(a -> a.createdAt);
    }

    @Override
    public Optional<Date> lastModifiedAt(String path) {
        return Optional.ofNullable(this.data.get(path)).map(a -> a.lastModifiedAt);
    }

    public void rememberState() {
        this.state.clear();
        for (Map.Entry<String, FileRecord> e : this.data.entrySet()) {
            this.state.put(e.getKey(), e.getValue());
        }
    }

    public void fireEvents() {
        for (String path : this.lookingForPaths.keySet()) {
            FileRecord nowBytes = this.data.get(path);
            FileRecord oldBytes = this.state.get(path);
            if (nowBytes != null && oldBytes != null) {
                if (Objects.equals(nowBytes, oldBytes)) continue;
                this.fireConfigEventHandler(path, ConfigEventType.UPDATE);
                continue;
            }
            if (nowBytes != null && oldBytes == null) {
                this.fireConfigEventHandler(path, ConfigEventType.CREATE);
                continue;
            }
            if (nowBytes != null || oldBytes == null) continue;
            this.fireConfigEventHandler(path, ConfigEventType.DELETE);
        }
    }

    @Override
    public void ensureLookingFor(String path) {
        this.lookingForPaths.put(path, true);
    }

    public List<String> getLinesWithoutSpaces(String path) {
        FileRecord bytes = this.data.get(path);
        if (bytes == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(new String(bytes.data, StandardCharsets.UTF_8).split("\\n"))).stream().map(s -> s.replaceAll("\\s+", "")).collect(Collectors.toList());
    }

    private static FileRecord addLines(FileRecord fileRecord, String[] lines) {
        ArrayList<String> lineList = fileRecord == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(new String(fileRecord.data, StandardCharsets.UTF_8).split("\\n")));
        lineList.addAll(Arrays.asList(lines));
        byte[] newBytes = String.join((CharSequence)"\n", lineList).getBytes(StandardCharsets.UTF_8);
        return fileRecord == null ? FileRecord.create(newBytes) : fileRecord.modify(newBytes);
    }

    private static FileRecord removeLines(FileRecord fileRecord, String[] lines) {
        if (fileRecord == null) {
            return null;
        }
        ArrayList<String> lineList = new ArrayList<String>(Arrays.asList(new String(fileRecord.data, StandardCharsets.UTF_8).split("\\n")));
        lineList.removeAll(Arrays.asList(lines));
        if (lineList.isEmpty()) {
            return null;
        }
        return fileRecord.modify(String.join((CharSequence)"\n", lineList).getBytes(StandardCharsets.UTF_8));
    }

    public void addLines(String path, String ... lines) {
        FileRecord newBytes;
        FileRecord bytes;
        do {
            bytes = this.data.get(path);
            newBytes = EventConfigStorageInMem.addLines(bytes, lines);
        } while (!(bytes == null ? this.data.putIfAbsent(path, newBytes) == null : this.data.replace(path, bytes, newBytes)));
    }

    public void removeLines(String path, String ... lines) {
        FileRecord bytes;
        FileRecord newBytes;
        do {
            if (!Objects.equals(bytes = this.data.get(path), newBytes = EventConfigStorageInMem.removeLines(bytes, lines))) continue;
            return;
        } while (!(newBytes == null ? this.data.remove(path, bytes) : this.data.replace(path, bytes, newBytes)));
    }

    private void writeLine(String line) {
        PrintStream out = System.out;
        out.println(line);
    }

    public void printCurrentState() {
        List list = this.data.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        for (Map.Entry e : list) {
            this.writeLine("FILE " + (String)e.getKey());
            String[] lines = new String(((FileRecord)e.getValue()).data, StandardCharsets.UTF_8).split("\n");
            if (lines.length > 0) {
                int len = ("" + (lines.length - 1)).length();
                int no = 1;
                for (String line : lines) {
                    this.writeLine("LINE " + KafkaStrUtil.intToStrLen(no++, len) + " : " + line);
                }
            }
            this.writeLine("");
        }
    }

    private static class FileRecord {
        final Date createdAt;
        final Date lastModifiedAt;
        final byte[] data;

        public FileRecord(Date createdAt, byte[] data) {
            this.createdAt = createdAt;
            this.lastModifiedAt = new Date();
            this.data = data;
        }

        public FileRecord(byte[] data) {
            this.lastModifiedAt = this.createdAt = new Date();
            this.data = data;
        }

        public static FileRecord create(byte[] data) {
            Objects.requireNonNull(data);
            return new FileRecord(data);
        }

        public FileRecord modify(byte[] data) {
            Objects.requireNonNull(data);
            return new FileRecord(this.createdAt, data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileRecord that = (FileRecord)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

