/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.util.Date;
import java.util.Optional;
import kz.greetgo.kafka.core.config.ConfigEventHandler;
import kz.greetgo.kafka.core.config.ConfigEventType;
import kz.greetgo.kafka.core.config.EventConfigStorage;
import kz.greetgo.kafka.core.config.EventRegistration;

public class EventConfigStorageUtil {
    public static EventConfigStorage changeRoot(String upPath, EventConfigStorage parent) {
        return new ChangedRoot(upPath, parent);
    }

    private static class ChangedRoot
    implements EventConfigStorage {
        private final String upPath;
        private final EventConfigStorage parent;

        public ChangedRoot(String upPath, EventConfigStorage parent) {
            this.upPath = upPath;
            this.parent = parent;
        }

        private String changePath(String path) {
            if (path == null || path.length() == 0) {
                return this.upPath;
            }
            return this.upPath + "/" + path;
        }

        @Override
        public Optional<Date> createdAt(String path) {
            return this.parent.createdAt(this.changePath(path));
        }

        @Override
        public Optional<Date> lastModifiedAt(String path) {
            return this.parent.lastModifiedAt(this.changePath(path));
        }

        @Override
        public byte[] readContent(String path) {
            return this.parent.readContent(this.changePath(path));
        }

        @Override
        public void writeContent(String path, byte[] content) {
            this.parent.writeContent(this.changePath(path), content);
        }

        @Override
        public void ensureLookingFor(String path) {
            this.parent.ensureLookingFor(this.changePath(path));
        }

        @Override
        public EventRegistration addEventHandler(final ConfigEventHandler configEventHandler) {
            return this.parent.addEventHandler(new ConfigEventHandler(){

                @Override
                public void configEventHappened(String path, ConfigEventType type) {
                    if (path.startsWith(upPath + "/")) {
                        configEventHandler.configEventHappened(path.substring(upPath.length() + 1), type);
                    }
                }
            });
        }

        @Override
        public void close() {
        }
    }
}

