/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.config;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kz.greetgo.kafka.core.config.ZooConnectParams;
import org.apache.curator.framework.AuthInfo;
import org.apache.zookeeper.client.ZKClientConfig;

public class ZooConnectParamsBuilder {
    private IntSupplier sessionTimeoutMs = () -> 10000;
    private IntSupplier connectionTimeoutMs = () -> 5000;
    private IntSupplier sleepMsBetweenRetriesMs = () -> 700;
    private IntSupplier maxRetries = () -> 3;
    private Supplier<Map<String, String>> config = Map::of;
    private Supplier<List<AuthInfo>> authInfoList = List::of;

    ZooConnectParamsBuilder() {
    }

    public ZooConnectParamsBuilder maxRetries(IntSupplier maxRetries) {
        this.maxRetries = Objects.requireNonNull(maxRetries);
        return this;
    }

    public ZooConnectParamsBuilder config(Supplier<Map<String, String>> config) {
        this.config = config;
        return this;
    }

    public ZooConnectParamsBuilder authInfoList(Supplier<List<AuthInfo>> authInfoList) {
        this.authInfoList = authInfoList;
        return this;
    }

    public ZooConnectParamsBuilder connectionTimeoutMs(IntSupplier connectionTimeoutMs) {
        this.connectionTimeoutMs = Objects.requireNonNull(connectionTimeoutMs);
        return this;
    }

    public ZooConnectParamsBuilder sessionTimeoutMs(IntSupplier sessionTimeoutMs) {
        this.sessionTimeoutMs = Objects.requireNonNull(sessionTimeoutMs);
        return this;
    }

    public ZooConnectParamsBuilder sleepMsBetweenRetriesMs(IntSupplier sleepMsBetweenRetriesMs) {
        this.sleepMsBetweenRetriesMs = Objects.requireNonNull(sleepMsBetweenRetriesMs);
        return this;
    }

    public ZooConnectParams build() {
        return new ZooConnectParams(){

            @Override
            public int sessionTimeoutMs() {
                return ZooConnectParamsBuilder.this.sessionTimeoutMs.getAsInt();
            }

            @Override
            public int connectionTimeoutMs() {
                return ZooConnectParamsBuilder.this.connectionTimeoutMs.getAsInt();
            }

            @Override
            public int sleepMsBetweenRetriesMs() {
                return ZooConnectParamsBuilder.this.sleepMsBetweenRetriesMs.getAsInt();
            }

            @Override
            public ZKClientConfig zkClientConfig() {
                ZKClientConfig ret = new ZKClientConfig();
                ZooConnectParamsBuilder.this.config.get().forEach((arg_0, arg_1) -> ((ZKClientConfig)ret).setProperty(arg_0, arg_1));
                return ret;
            }

            @Override
            public List<AuthInfo> authInfoList() {
                return ZooConnectParamsBuilder.this.authInfoList.get();
            }

            @Override
            public int maxRetries() {
                return ZooConnectParamsBuilder.this.maxRetries.getAsInt();
            }
        };
    }
}

