/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.consumer_filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.ConsumerFilter;
import kz.greetgo.kafka.core.consumer_filter.ConsumerFilterRegistrar;
import kz.greetgo.kafka.core.consumer_filter.CustomFilterRegistration;
import kz.greetgo.kafka.model.Box;

public class ConsumerFilterManager
implements ConsumerFilterRegistrar,
ConsumerFilter {
    private final AtomicLong nextId = new AtomicLong(1L);
    private final ThreadLocal<ConcurrentHashMap<Long, ConsumerFilter>> localThreadFilters = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private final ConcurrentHashMap<Long, ConsumerFilter> allThreadsFilters = new ConcurrentHashMap();

    @Override
    public CustomFilterRegistration registerForLocalThread(ConsumerFilter consumerFilter) {
        Objects.requireNonNull(consumerFilter, "g6VB5dX1WS :: consumerFilter == null");
        ConcurrentHashMap<Long, ConsumerFilter> workingMap = this.localThreadFilters.get();
        long registerId = this.nextId.getAndIncrement();
        workingMap.put(registerId, consumerFilter);
        return () -> workingMap.remove(registerId);
    }

    @Override
    public CustomFilterRegistration registerForAllThreads(ConsumerFilter consumerFilter) {
        Objects.requireNonNull(consumerFilter, "k4Wh3UYi1o :: consumerFilter == null");
        long registerId = this.nextId.getAndIncrement();
        this.allThreadsFilters.put(registerId, consumerFilter);
        return () -> this.allThreadsFilters.remove(registerId);
    }

    @Override
    public boolean isInFilter(ConsumerDefinition consumerDefinition, Box box, byte[] recordKey) {
        if (!ConsumerFilterManager.isInFilters(this.localThreadFilters.get(), consumerDefinition, box, recordKey)) {
            return false;
        }
        return ConsumerFilterManager.isInFilters(this.allThreadsFilters, consumerDefinition, box, recordKey);
    }

    private static boolean isInFilters(ConcurrentHashMap<Long, ConsumerFilter> allThreadsFilters, ConsumerDefinition consumerDefinition, Box box, byte[] recordKey) {
        List list = allThreadsFilters.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        for (ConsumerFilter consumerFilter : list) {
            if (consumerFilter.isInFilter(consumerDefinition, box, recordKey)) continue;
            return false;
        }
        return true;
    }
}

