/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.logger;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.logger.LogMessageAcceptor;
import kz.greetgo.kafka.core.logger.LoggerDestination;
import kz.greetgo.kafka.core.logger.LoggerDestinationMessageBridge;
import kz.greetgo.kafka.core.logger.LoggerExternal;
import kz.greetgo.kafka.core.logger.LoggerType;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class Logger
implements LoggerExternal {
    private LoggerDestination destination = null;
    private static final Predicate<LoggerType> SHOW_ALL = x -> true;
    private final AtomicReference<Predicate<LoggerType>> loggerTypeFilter = new AtomicReference<Predicate<LoggerType>>(SHOW_ALL);
    private Predicate<Throwable> errorSkipper = x -> false;

    @Override
    public void setDestination(LoggerDestination destination) {
        this.destination = destination;
    }

    @Override
    public void setDestination(LogMessageAcceptor acceptor) {
        this.destination = acceptor == null ? null : LoggerDestinationMessageBridge.of(acceptor);
    }

    @Override
    public void setLoggerTypeFilter(Predicate<LoggerType> loggerTypeFilter) {
        this.loggerTypeFilter.set(Objects.requireNonNullElse(loggerTypeFilter, SHOW_ALL));
    }

    public boolean isShow(LoggerType loggerType) {
        if (this.destination == null) {
            return false;
        }
        return this.loggerTypeFilter.get().test(loggerType);
    }

    public void logProducerConfigOnCreating(String producerName, Map<String, Object> configMap) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerConfigOnCreating(producerName, configMap);
        }
    }

    public void logProducerClosed(String producerName, Profile profile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerClosed(producerName, profile);
        }
    }

    public void logConsumerStartWorker(ConsumerDefinition consumerDefinition, long workerId, Profile workerProfile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerStartWorker(consumerDefinition, workerId, workerProfile);
        }
    }

    public void logConsumerFinishWorker(ConsumerDefinition consumerDefinition, long workerId, Profile workerProfile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerFinishWorker(consumerDefinition, workerId, workerProfile);
        }
    }

    public void logConsumerErrorInvoking(Throwable throwable, String consumerName, Profile profile) {
        if (this.errorSkipper.test(throwable)) {
            return;
        }
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerErrorInvoking(throwable, consumerName, profile);
        }
    }

    public void logConsumerWorkerConfig(ConsumerDefinition consumerDefinition, long workerId, Map<String, Object> configMap, Profile workerProfile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerWorkerConfig(consumerDefinition, workerId, configMap, workerProfile);
        }
    }

    public void logConsumerIllegalAccessExceptionInvoking(IllegalAccessException e, String invokingInfo) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerIllegalAccessExceptionInvoking(e, invokingInfo);
        }
    }

    public void logConsumerReactorRefresh(ConsumerDefinition consumerDefinition, int currentCount, int needCount, Profile profile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerReactorRefresh(consumerDefinition, currentCount, needCount, profile);
        }
    }

    public void logConsumerPollExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition, Profile workerProfile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerPollExceptionHappened(exception, consumerDefinition, workerProfile);
        }
    }

    public void logConsumerLogDirectInvokeError(Throwable error) {
        if (this.errorSkipper.test(error)) {
            return;
        }
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerLogDirectInvokeError(error);
        }
    }

    public void logConsumerCommitSyncExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerCommitSyncExceptionHappened(exception, consumerDefinition);
        }
    }

    public void logProducerCreated(String producerName, Profile profile) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerCreated(producerName, profile);
        }
    }

    public void logProducerValidationError(Throwable error) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerValidationError(error);
        }
    }

    public void logProducerAwaitAndGetError(String errorCode, Exception exception) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerAwaitAndGetError(errorCode, exception);
        }
    }

    public void setErrorSkipper(Predicate<Throwable> errorSkipper) {
        this.errorSkipper = Objects.requireNonNull(errorSkipper, "3n5Qk0id57 :: errorSkipper");
    }

    public void logProducerDirectConsumerError(String lineCode, Exception error, ConsumerDefinition consumerDefinition) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logProducerDirectConsumerError(lineCode, error, consumerDefinition);
        }
    }

    public void logConsumerPollZero(ConsumerDefinition consumerDefinition) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerPollZero(consumerDefinition);
        }
    }

    public void logConsumerPollPerformDelay(ConsumerDefinition consumerDefinition, long pollPerformDelayMs, ConsumerRecords<byte[], Object> records) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logConsumerPollPerformDelay(consumerDefinition, pollPerformDelayMs, records);
        }
    }

    public void logErrorRefreshTopicList(Exception error) {
        LoggerDestination d = this.destination;
        if (d != null) {
            d.logErrorRefreshTopicList(error);
        }
    }
}

