/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.core.logger;

import java.util.Map;
import java.util.function.Supplier;
import kz.greetgo.kafka.consumer.ConsumerDefinition;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.logger.LogMessageAcceptor;
import kz.greetgo.kafka.core.logger.LoggerDestination;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class LoggerDestinationMessageBridge
implements LoggerDestination {
    private final LogMessageAcceptor acceptor;

    private LoggerDestinationMessageBridge(LogMessageAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public static LoggerDestinationMessageBridge of(LogMessageAcceptor acceptor) {
        return new LoggerDestinationMessageBridge(acceptor);
    }

    @Override
    public void logProducerConfigOnCreating(String producerName, Map<String, Object> configMap) {
        if (this.acceptor.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("eaq327lA56 :: Created producer `").append(producerName).append("` with config:");
            configMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> sb.append("\n    ").append((String)e.getKey()).append(" = `").append(e.getValue()).append("`"));
            this.acceptor.info(sb.toString());
        }
    }

    @Override
    public void logProducerClosed(String producerName, Profile profile) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("eg3VjG8LJ2 :: Closed producer `" + producerName + "` on " + profile);
        }
    }

    @Override
    public void logProducerCreated(String producerName, Profile profile) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("H07lNf5CWz :: Created producer `" + producerName + "` on " + profile);
        }
    }

    @Override
    public void logConsumerStartWorker(ConsumerDefinition consumerDefinition, long workerId, Profile workerProfile) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("Qd7yBcyWxr :: Started consumer worker `" + consumerDefinition.logDisplay() + "` with id = " + workerId + " on " + workerProfile + " in thread " + Thread.currentThread().getName());
        }
    }

    @Override
    public void logConsumerFinishWorker(ConsumerDefinition consumerDefinition, long workerId, Profile workerProfile) {
        if (this.acceptor.isInfoEnabled()) {
            this.acceptor.info("CP7mAW9YKx :: Finished consumer worker `" + consumerDefinition.logDisplay() + "` with id = " + workerId + " in " + workerProfile);
        }
    }

    @Override
    public void debug(Supplier<String> message) {
        if (this.acceptor.isDebugEnabled()) {
            this.acceptor.debug(message.get());
        }
    }

    @Override
    public void logConsumerErrorInvoking(Throwable throwable, String consumerName, Profile profile) {
        this.acceptor.error("2GAwFLdp66 :: Error in invoking custom consumer: " + consumerName + " " + profile, throwable);
    }

    @Override
    public void logConsumerWorkerConfig(ConsumerDefinition consumerDefinition, long workerId, Map<String, Object> configMap, Profile workerProfile) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("2Xl54Xw3U8 :: Consumer worker config: consumer = `").append(consumerDefinition.logDisplay()).append("`").append(", workerId = `").append(workerId).append("` ").append(workerProfile).append("\n");
        configMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> sb.append("\n    ").append((String)e.getKey()).append(" = `").append(e.getValue()).append("`"));
        this.acceptor.info(sb.toString());
    }

    @Override
    public void logProducerDirectConsumerError(String lineCode, Exception error, ConsumerDefinition consumerDefinition) {
        this.acceptor.error(lineCode + " :: DIRECT Consumer = " + consumerDefinition.logDisplay(), error);
    }

    @Override
    public void logErrorRefreshTopicList(Exception error) {
        this.acceptor.error("4UjjGRH7K5 :: Refresh topic list", error);
    }

    @Override
    public void logConsumerIllegalAccessExceptionInvoking(IllegalAccessException e, String invokerInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("yv36s1a1yn :: IllegalAccessException invoking ").append(invokerInfo);
        this.acceptor.error(sb.toString(), e);
    }

    @Override
    public void logConsumerPollExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition, Profile workerProfile) {
        this.acceptor.error("3FsKY038mh :: Poll exception in consumer " + consumerDefinition.logDisplay() + " in " + workerProfile, exception);
    }

    @Override
    public void logConsumerCommitSyncExceptionHappened(RuntimeException exception, ConsumerDefinition consumerDefinition) {
        this.acceptor.error("In0PflFViW :: CommitSync exception in consumer " + consumerDefinition.logDisplay(), exception);
    }

    @Override
    public void logProducerValidationError(Throwable error) {
        this.acceptor.error("XxLY0m1mzb :: Producer validation error", error);
    }

    @Override
    public void logProducerAwaitAndGetError(String errorCode, Exception exception) {
        this.acceptor.error(errorCode + " :: Producer AwaitAndGet Error", exception);
    }

    @Override
    public void logConsumerLogDirectInvokeError(Throwable error) {
        this.acceptor.error("Consumer ERROR", error);
    }

    @Override
    public void logConsumerReactorRefresh(ConsumerDefinition consumerDefinition, int currentCount, int needCount, Profile profile) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        this.acceptor.info("BO55WO1GEV :: Refresh consumer count = " + currentCount + " --> " + needCount + "; " + consumerDefinition.logDisplay() + " of " + profile);
    }

    @Override
    public void logConsumerPollZero(ConsumerDefinition consumerDefinition) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        this.acceptor.info("U1HoFbkMtu :: Poll zero " + consumerDefinition.logDisplay());
    }

    @Override
    public void logConsumerPollPerformDelay(ConsumerDefinition consumerDefinition, long pollPerformDelayMs, ConsumerRecords<byte[], Object> records) {
        if (!this.acceptor.isInfoEnabled()) {
            return;
        }
        this.acceptor.info("nWeJWP1bx7 :: Poll delay " + pollPerformDelayMs + " ms, recordCount=" + (String)(records == null ? "(records==null)" : "" + records.count()) + " : " + consumerDefinition.logDisplay());
    }
}

