/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kz.greetgo.kafka.errors.future.ExecutionExceptionWrapper;
import kz.greetgo.kafka.errors.future.InterruptedExceptionWrapper;
import kz.greetgo.kafka.errors.future.TimeoutExceptionWrapper;
import kz.greetgo.kafka.producer.KafkaFuture;
import org.apache.kafka.clients.producer.RecordMetadata;

public abstract class KafkaFutureAbstract
implements KafkaFuture {
    protected final Future<RecordMetadata> source;

    protected KafkaFutureAbstract(Future<RecordMetadata> source) {
        this.source = source;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.source.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.source.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.source.isDone();
    }

    @Override
    public RecordMetadata awaitAndGet() {
        return this.awaitAndGet(true);
    }

    protected abstract void intercept(boolean var1);

    @Override
    public RecordMetadata awaitAndGet(boolean applyInterceptors) {
        try {
            RecordMetadata recordMetadata = this.source.get();
            this.intercept(applyInterceptors);
            return recordMetadata;
        }
        catch (InterruptedException e) {
            throw new InterruptedExceptionWrapper(e);
        }
        catch (ExecutionException e) {
            throw new ExecutionExceptionWrapper(e);
        }
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) {
        try {
            RecordMetadata recordMetadata = this.source.get(timeout, unit);
            this.intercept(true);
            return recordMetadata;
        }
        catch (InterruptedException e) {
            throw new InterruptedExceptionWrapper(e);
        }
        catch (ExecutionException e) {
            throw new ExecutionExceptionWrapper(e);
        }
        catch (TimeoutException e) {
            throw new TimeoutExceptionWrapper(e);
        }
    }
}

