/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.BoxInterceptor;
import kz.greetgo.kafka.core.ProducerSynchronizer;
import kz.greetgo.kafka.core.logger.LoggerType;
import kz.greetgo.kafka.model.Box;
import kz.greetgo.kafka.producer.BoxRecord;
import kz.greetgo.kafka.producer.KafkaFuture;
import kz.greetgo.kafka.producer.KafkaFutureBox;
import kz.greetgo.kafka.producer.ProducerFacadeAbstract;
import kz.greetgo.kafka.producer.ProducerSource;
import kz.greetgo.kafka.serializer.BoxSerializer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.Serializer;

public class ProducerFacadeBox
extends ProducerFacadeAbstract<Object> {
    private final BoxInterceptor boxInterceptor;

    private ProducerFacadeBox(String producerName, ProducerSource source, ProducerSynchronizer producerSynchronizer, Supplier<String> topicPrefix, BoxInterceptor boxInterceptor) {
        super(source, producerName, producerSynchronizer, topicPrefix);
        this.boxInterceptor = boxInterceptor;
    }

    @Nonnull
    public static ProducerFacadeBox create(String producerName, ProducerSource source, ProducerSynchronizer producerSynchronizer, Supplier<String> topicPrefix, BoxInterceptor boxInterceptor) {
        return new ProducerFacadeBox(producerName, source, producerSynchronizer, topicPrefix, boxInterceptor);
    }

    @Override
    protected Serializer<Object> createValueSerializer() {
        return new BoxSerializer(this.source.getStrConverter());
    }

    @Override
    protected KafkaFuture doSend(@Nonnull Object message, String toTopic, byte[] withKey, Integer toPartition, Long timestamp, String author, String kafkaId, @Nonnull ArrayList<Header> headers, @Nonnull Profile profile) {
        if (toTopic == null) {
            throw new RuntimeException("nSzM90vC3V :: topic == null");
        }
        Box box = new Box();
        box.body = message;
        box.a = author;
        box.id = kafkaId;
        try {
            box.validate();
        }
        catch (Throwable throwable) {
            if (this.source.logger().isShow(LoggerType.LOG_PRODUCER_VALIDATION_ERROR)) {
                this.source.logger().logProducerValidationError(throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        byte[] key = withKey != null ? withKey : this.source.extractKey(message);
        BoxRecord record = new BoxRecord(toTopic, this.doPrefixTopic(toTopic), toPartition, timestamp, key, box, headers, profile);
        Producer nativeProducer = this.getNativeProducer(profile);
        Future future = nativeProducer.send(record.toProducerRecord());
        return new KafkaFutureBox(future, record, this.boxInterceptor);
    }
}

