/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.ProducerStrInterceptor;
import kz.greetgo.kafka.core.ProducerSynchronizer;
import kz.greetgo.kafka.producer.KafkaFuture;
import kz.greetgo.kafka.producer.KafkaFutureStr;
import kz.greetgo.kafka.producer.ProducerFacadeAbstract;
import kz.greetgo.kafka.producer.ProducerSource;
import kz.greetgo.kafka.producer.RecordStr;
import kz.greetgo.kafka.serializer.StrSerializer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.Serializer;

public class ProducerFacadeStr
extends ProducerFacadeAbstract<String> {
    private final ProducerStrInterceptor strInterceptor;

    private ProducerFacadeStr(String producerName, ProducerSource source, ProducerSynchronizer producerSynchronizer, Supplier<String> topicPrefix, ProducerStrInterceptor strInterceptor) {
        super(source, producerName, producerSynchronizer, topicPrefix);
        this.strInterceptor = strInterceptor;
    }

    @Nonnull
    public static ProducerFacadeStr create(String producerName, ProducerSource source, ProducerSynchronizer producerSynchronizer, Supplier<String> topicPrefix, ProducerStrInterceptor strInterceptor) {
        return new ProducerFacadeStr(producerName, source, producerSynchronizer, topicPrefix, strInterceptor);
    }

    @Override
    protected Serializer<String> createValueSerializer() {
        return new StrSerializer();
    }

    @Override
    protected KafkaFuture doSend(@Nonnull String message, String toTopic, byte[] withKey, Integer toPartition, Long timestamp, String author, String kafkaId, @Nonnull ArrayList<Header> headers, @Nonnull Profile profile) {
        if (toTopic == null) {
            throw new RuntimeException("1I8z1gdBrY :: topic == null");
        }
        byte[] key = withKey != null ? withKey : this.source.extractKey(message);
        RecordStr record = new RecordStr(toTopic, this.doPrefixTopic(toTopic), toPartition, timestamp, key, message, headers, profile);
        Producer nativeProducer = this.getNativeProducer(profile);
        Future future = nativeProducer.send(record.toProducerRecord());
        return new KafkaFutureStr(future, record, this.strInterceptor);
    }
}

