/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.Profile;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;

public class RecordStr {
    public final String appTopic;
    public final String prefixedTopic;
    public final Integer partition;
    public final Long timestamp;
    public final byte[] key;
    public final String message;
    public final List<Header> headers;
    public final Profile profile;

    public RecordStr(String appTopic, String prefixedTopic, Integer partition, Long timestamp, byte[] key, String message, List<Header> headers, @Nonnull Profile profile) {
        this.appTopic = appTopic;
        this.prefixedTopic = prefixedTopic;
        this.partition = partition;
        this.timestamp = timestamp;
        this.key = key;
        this.message = message;
        this.headers = headers;
        this.profile = profile;
    }

    public ProducerRecord<byte[], String> toProducerRecord() {
        return new ProducerRecord(this.prefixedTopic, this.partition, this.timestamp, (Object)this.key, (Object)this.message, this.headers);
    }

    private int partition() {
        Integer x = this.partition;
        return x != null ? x : 0;
    }

    public ConsumerRecords<byte[], String> toConsumerRecords() {
        TopicPartition topicPartition = new TopicPartition(this.prefixedTopic, this.partition());
        ConsumerRecord consumerRecord = new ConsumerRecord(this.prefixedTopic, this.partition(), 0L, (Object)this.key, (Object)this.message);
        return new ConsumerRecords(Map.of(topicPartition, List.of(consumerRecord)));
    }
}

