/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kz.greetgo.kafka.util.KeyValue;

public class ProducerConfigDefaults {
    private final List<KeyValue> lineList = new ArrayList<KeyValue>();

    public void append(String key, String value) {
        this.lineList.add(KeyValue.of(key, value));
    }

    public void append(String definition) {
        int idx = definition.indexOf(61);
        if (idx < 0) {
            throw new RuntimeException("6UAkQ60bxb :: Unknown definition " + definition);
        }
        this.append(definition.substring(0, idx).trim(), definition.substring(idx + 1).trim());
    }

    private ProducerConfigDefaults() {
    }

    public static ProducerConfigDefaults empty() {
        return new ProducerConfigDefaults();
    }

    public static ProducerConfigDefaults defaults() {
        ProducerConfigDefaults ret = ProducerConfigDefaults.empty();
        ret.appendDefaults();
        return ret;
    }

    public void appendDefaults() {
        this.append("  prod.acks                      =  all      ");
        this.append("  prod.buffer.memory             =  33554432 ");
        this.append("  prod.compression.type          =  lz4      ");
        this.append("  prod.batch.size                =  16384    ");
        this.append("  prod.connections.max.idle.ms   =  540000   ");
        this.append("  prod.request.timeout.ms        =  30000    ");
        this.append("  prod.linger.ms                 =  1        ");
        this.append("  prod.retries                                 =  2147483647    ");
        this.append("  prod.max.in.flight.requests.per.connection   =  1             ");
        this.append("  prod.delivery.timeout.ms                     =  35000         ");
        this.append("  prod.max.block.ms                            =  25000         ");
    }

    public List<String> toConfigFileLines() {
        return this.lineList.stream().map(line -> line.key() + " = " + line.value()).collect(Collectors.toList());
    }
}

