/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.producer.config;

import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.core.config.EventConfigFile;
import kz.greetgo.kafka.core.config.EventConfigFileFactory;
import kz.greetgo.kafka.producer.ProducerConfigDefaultsAccess;
import kz.greetgo.kafka.producer.config.ProducerReactorConfig;

public class ProducerReactorConfigFactory
implements AutoCloseable {
    private final EventConfigFileFactory configFactory;
    private final ProducerConfigDefaultsAccess defaults;
    private final String configFileExtension;
    private final ConcurrentHashMap<String, ProducerReactorConfig> configMap = new ConcurrentHashMap();
    private final Object sync = new Object();

    public static Builder builder() {
        return new Builder();
    }

    private ProducerReactorConfigFactory(EventConfigFileFactory configFactory, ProducerConfigDefaultsAccess defaults, String configFileExtension) {
        this.configFactory = configFactory;
        this.defaults = defaults;
        this.configFileExtension = configFileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerReactorConfig getConfig(String producerName, @Nonnull Profile profile) {
        String fileName = producerName + (String)(profile.profile == null ? "" : "_" + profile.profile) + this.configFileExtension;
        ProducerReactorConfig x = this.configMap.get(fileName);
        if (x != null) {
            return x;
        }
        Object object = this.sync;
        synchronized (object) {
            ProducerReactorConfig x2 = this.configMap.get(fileName);
            if (x2 != null) {
                return x2;
            }
            EventConfigFile eventConfigFile = this.configFactory.createEventConfigFile(fileName);
            ProducerReactorConfig reactorConfig = new ProducerReactorConfig(eventConfigFile, () -> this.defaults.get(profile));
            this.configMap.put(fileName, reactorConfig);
            return reactorConfig;
        }
    }

    @Override
    public void close() throws Exception {
        while (this.configMap.size() > 0) {
            for (String key : new HashSet(this.configMap.keySet())) {
                ProducerReactorConfig config = this.configMap.remove(key);
                if (config == null) continue;
                config.close();
            }
        }
    }

    public static class Builder {
        private EventConfigFileFactory configFactory;
        private ProducerConfigDefaultsAccess defaults;
        private String configFileExtension = ".config";

        public Builder configFactory(EventConfigFileFactory configFactory) {
            this.configFactory = Objects.requireNonNull(configFactory, "H3K4sx1JSe :: configFactory == null");
            return this;
        }

        public Builder defaults(ProducerConfigDefaultsAccess defaults) {
            this.defaults = Objects.requireNonNull(defaults, "O0tJkQ1w6m :: defaults == null");
            return this;
        }

        public Builder configFileExtension(String configFileExtension) {
            this.configFileExtension = Objects.requireNonNull(configFileExtension, "W0DHu37rzC :: configFileExtension = null");
            return this;
        }

        public ProducerReactorConfigFactory build() {
            return new ProducerReactorConfigFactory(Objects.requireNonNull(this.configFactory), Objects.requireNonNull(this.defaults), Objects.requireNonNull(this.configFileExtension));
        }
    }
}

