/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.serializer;

import java.nio.charset.StandardCharsets;
import kz.greetgo.kafka.model.Box;
import kz.greetgo.kafka.serializer.DeserializerError;
import kz.greetgo.strconverter.StrConverter;
import org.apache.kafka.common.serialization.Deserializer;

public class BoxDeserializer
implements Deserializer<Object> {
    private final StrConverter strConverter;

    public BoxDeserializer(StrConverter strConverter) {
        this.strConverter = strConverter;
    }

    public Object deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            String str = new String(data, StandardCharsets.UTF_8);
            Object ret = this.strConverter.fromStr(str);
            return ret instanceof Box ? ret : null;
        }
        catch (Exception e) {
            return new DeserializerError(e, data);
        }
    }
}

