/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AnnotationUtil {
    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        T ann;
        while ((ann = method.getAnnotation(annotation)) == null) {
            Class<?> aClass = method.getDeclaringClass();
            if (aClass == Object.class) {
                return null;
            }
            Class<?> superclass = aClass.getSuperclass();
            if (superclass == null) {
                return null;
            }
            try {
                method = superclass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> source, Class<T> annotation) {
        return AnnotationUtil.getAnnotationInner(source, annotation, new HashSet());
    }

    private static <T extends Annotation> T getAnnotationInner(Class<?> source, Class<T> annotation, Set<Class<?>> cache) {
        if (source == null) {
            return null;
        }
        T ann = source.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        if (cache.contains(source)) {
            return null;
        }
        cache.add(source);
        for (Class<?> aClass : source.getInterfaces()) {
            T ann2 = AnnotationUtil.getAnnotationInner(aClass, annotation, cache);
            if (ann2 == null) continue;
            return ann2;
        }
        return AnnotationUtil.getAnnotationInner(source.getSuperclass(), annotation, cache);
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Objects.requireNonNull(method);
        ArrayList<Annotation[][]> all = new ArrayList<Annotation[][]>();
        AnnotationUtil.putParameterAnnotations(method, all);
        Annotation[][] ret = new Annotation[method.getParameterCount()][];
        int[] totalLengths = new int[ret.length];
        for (Annotation[][] annotations : all) {
            for (int i = 0; i < ret.length; ++i) {
                int n = i;
                totalLengths[n] = totalLengths[n] + annotations[i].length;
            }
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Annotation[totalLengths[i]];
        }
        int[] indexes = new int[ret.length];
        for (Annotation[][] annotations : all) {
            for (int i = 0; i < ret.length; ++i) {
                for (int j = 0; j < annotations[i].length; ++j) {
                    int n = i;
                    int n2 = indexes[n];
                    indexes[n] = n2 + 1;
                    ret[i][n2] = annotations[i][j];
                }
            }
        }
        return ret;
    }

    private static void putParameterAnnotations(Method method, List<Annotation[][]> dest) {
        HashSet cache = new HashSet();
        for (Class<?> current = method.getDeclaringClass(); current != null; current = current.getSuperclass()) {
            if (cache.contains(current)) {
                return;
            }
            cache.add(current);
            try {
                Method m = current.getDeclaredMethod(method.getName(), method.getParameterTypes());
                dest.add(m.getParameterAnnotations());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

