/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.util.ArrayList;
import java.util.List;
import kz.greetgo.kafka.util.ConfigLineCommand;
import kz.greetgo.kafka.util.ConfigLineKey;
import kz.greetgo.kafka.util.ConfigLineValue;
import kz.greetgo.kafka.util.KafkaStrUtil;
import kz.greetgo.kafka.util.ValueSelect;

public class ConfigLine {
    private final List<String> errors = new ArrayList<String>();
    private ConfigLineKey key;
    private ConfigLineValue value;
    private String line = null;

    public static ConfigLine parse(String line) {
        if (line == null) {
            return null;
        }
        return new ConfigLine(line);
    }

    private ConfigLine() {
    }

    public ConfigLine copy() {
        ConfigLine ret = new ConfigLine();
        ret.key = this.key == null ? null : this.key.copy();
        ret.value = this.value == null ? null : this.value.copy();
        ret.line = this.line;
        ret.errors.addAll(this.errors);
        return ret;
    }

    public String line() {
        return this.line != null ? this.line : (this.key == null || this.value == null ? "" : this.key.toString() + this.value.toString());
    }

    private ConfigLine(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.isEmpty() || trimmedLine.startsWith("##")) {
            this.line = line;
            this.key = null;
            this.value = null;
            return;
        }
        this.key = ConfigLineKey.parse(line);
        this.value = ConfigLineValue.parse(line);
        if (this.key == null || this.value == null) {
            this.key = null;
            this.value = null;
            this.line = line;
            this.errors.add("Unknown format of line `" + line + "`");
        }
    }

    public boolean isCommented() {
        return this.key == null || this.key.isCommented();
    }

    public String key() {
        return this.key == null ? null : this.key.key();
    }

    public ConfigLineCommand command() {
        return this.value == null ? null : this.value.command();
    }

    public String value() {
        return this.value == null ? null : this.value.value();
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public String keyPart() {
        return this.key == null ? null : this.key.toString();
    }

    public String valuePart() {
        return this.value == null ? null : this.value.toString();
    }

    public List<String> errors() {
        ArrayList<String> ret = new ArrayList<String>();
        ConfigLineValue value = this.value;
        if (value != null) {
            ret.addAll(value.errors());
        }
        ret.addAll(this.errors);
        return ret;
    }

    public void setValue(String newValue) {
        if (this.value == null) {
            throw new IllegalStateException("value == null in method ConfigLine.setValue()");
        }
        this.value.setValue(newValue);
    }

    public void setCommented(boolean commented) {
        if (this.key == null) {
            throw new IllegalStateException("key == null in method ConfigLine.setCommented()");
        }
        this.key.setCommented(commented);
    }

    public void setCommand(ConfigLineCommand command) {
        if (command == null) {
            throw new IllegalArgumentException("command == null in method ConfigLine.setCommand()");
        }
        if (this.value == null) {
            throw new IllegalStateException("value == null in method ConfigLine.setCommand()");
        }
        this.value.setCommand(command);
    }

    public void setKey(String key) {
        if (this.key == null) {
            String line = "#" + key + " : null";
            this.line = null;
            this.key = ConfigLineKey.parse(line);
            this.value = ConfigLineValue.parse(line);
            return;
        }
        this.key.setKey(key);
    }

    public boolean isValueEqualTo(String value) {
        if (this.value == null) {
            return false;
        }
        return this.value.isValueEqualTo(value);
    }

    public boolean isEqualTo(ValueSelect valueSelect) {
        if (valueSelect == null) {
            return false;
        }
        return valueSelect.equals(this.get());
    }

    public String toString() {
        return this.line();
    }

    public void set(ValueSelect valueSelect) {
        if (valueSelect == null) {
            throw new IllegalArgumentException("valueSelect == null");
        }
        String value = valueSelect.value();
        if (value != null) {
            this.setValue(value);
            return;
        }
        ConfigLineCommand command = valueSelect.command();
        if (command != null) {
            this.setCommand(command);
        }
    }

    public ValueSelect get() {
        String value = this.value();
        if (value != null) {
            return ValueSelect.of(value);
        }
        ConfigLineCommand command = this.command();
        if (command != null) {
            return ValueSelect.of(command);
        }
        throw new IllegalStateException("ConfigLineValue.value() == null && ConfigLineValue.command() == null");
    }

    public void ensureError(String error) {
        KafkaStrUtil.addIfAbsent(this.errors, error);
    }
}

