/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import kz.greetgo.kafka.util.KafkaStrUtil;

public class ConfigLineKey {
    private String key;
    private int paddingLeft1;
    private int paddingLeft2;
    private int width;
    private boolean commented;

    public static ConfigLineKey parse(String line) {
        if (line == null) {
            return null;
        }
        if (line.trim().startsWith("##")) {
            return null;
        }
        int index = KafkaStrUtil.firstIndexOf(line, '=', ':');
        if (index < 0) {
            return null;
        }
        return new ConfigLineKey(line.substring(0, index));
    }

    private ConfigLineKey(String text) {
        String trimmedText = text.trim();
        if (trimmedText.startsWith("#")) {
            this.commented = true;
            String subText = trimmedText.substring(1);
            this.key = subText.trim();
            this.paddingLeft1 = KafkaStrUtil.startSpacesCount(text);
            this.paddingLeft2 = KafkaStrUtil.startSpacesCount(subText) + 1;
        } else {
            this.commented = false;
            this.key = trimmedText;
            this.paddingLeft1 = 0;
            this.paddingLeft2 = KafkaStrUtil.startSpacesCount(text);
        }
        this.width = text.length() - this.paddingLeft1 - this.paddingLeft2;
    }

    private ConfigLineKey() {
    }

    public ConfigLineKey copy() {
        ConfigLineKey ret = new ConfigLineKey();
        ret.key = this.key;
        ret.paddingLeft1 = this.paddingLeft1;
        ret.paddingLeft2 = this.paddingLeft2;
        ret.width = this.width;
        ret.commented = this.commented;
        return ret;
    }

    public String key() {
        return this.key;
    }

    public int paddingLeft1() {
        return this.paddingLeft1;
    }

    public int paddingLeft2() {
        return this.paddingLeft2;
    }

    public int width() {
        return this.width;
    }

    public boolean isCommented() {
        return this.commented;
    }

    public void setKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        this.key = key;
        this.width = Math.max(this.width, key.length());
    }

    public void setCommented(boolean commented) {
        this.commented = commented;
        if (this.paddingLeft2 == 0) {
            this.paddingLeft2 = 1;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.paddingLeft1 + this.paddingLeft2 + this.width + 10);
        sb.append(KafkaStrUtil.spaces(this.paddingLeft1));
        if (this.commented) {
            sb.append('#');
            if (this.paddingLeft2 > 1) {
                sb.append(KafkaStrUtil.spaces(this.paddingLeft2 - 1));
            }
        } else {
            sb.append(KafkaStrUtil.spaces(this.paddingLeft2));
        }
        sb.append(this.key);
        int needLength = this.paddingLeft1 + this.paddingLeft2 + this.width;
        while (sb.length() < needLength) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

