/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kz.greetgo.kafka.util.ConfigLineCommand;
import kz.greetgo.kafka.util.KafkaStrUtil;

public class ConfigLineValue {
    private final List<String> errors = new ArrayList<String>();
    private String value;
    private int paddingLeft;
    private int width;
    private String command;

    public static ConfigLineValue parse(String line) {
        if (line == null) {
            return null;
        }
        if (line.trim().startsWith("##")) {
            return null;
        }
        int index = KafkaStrUtil.firstIndexOf(line, '=', ':');
        if (index < 0) {
            return null;
        }
        return new ConfigLineValue(line.substring(index));
    }

    private ConfigLineValue(String valuePart) {
        char firstChar = valuePart.charAt(0);
        String text = valuePart.substring(1);
        this.paddingLeft = KafkaStrUtil.startSpacesCount(text);
        this.width = text.length() - this.paddingLeft;
        if (this.width == 0 && this.paddingLeft > 0) {
            this.width = this.paddingLeft - 1;
            this.paddingLeft = 1;
        }
        if (firstChar == '=') {
            this.value = text.trim();
            this.command = null;
            return;
        }
        if (firstChar == ':') {
            this.command = text.trim();
            if (ConfigLineCommand.valueOrUnknown(this.command) == ConfigLineCommand.UNKNOWN) {
                this.errors.add("Unknown command `" + this.command + "`");
            }
            return;
        }
        throw new IllegalArgumentException("Unknown firstChar = " + firstChar);
    }

    private ConfigLineValue() {
    }

    public ConfigLineValue copy() {
        ConfigLineValue ret = new ConfigLineValue();
        ret.value = this.value;
        ret.paddingLeft = this.paddingLeft;
        ret.width = this.width;
        ret.command = this.command;
        return ret;
    }

    public String value() {
        return this.value;
    }

    public ConfigLineCommand command() {
        return this.command == null ? null : ConfigLineCommand.valueOrUnknown(this.command);
    }

    public int paddingLeft() {
        return this.paddingLeft;
    }

    public int width() {
        return this.width;
    }

    public void setValue(String value) {
        if (value == null) {
            this.command = ConfigLineCommand.NULL.name().toLowerCase();
            this.value = null;
        } else {
            this.value = value;
            this.command = null;
        }
        this.updateWidth();
    }

    private void updateWidth() {
        if (this.command != null) {
            this.width = Math.max(this.width, this.command.length());
        }
        if (this.value != null) {
            this.width = Math.max(this.width, this.value.length());
        }
    }

    public List<String> errors() {
        return this.errors;
    }

    public void setCommand(ConfigLineCommand command) {
        if (command == null) {
            command = ConfigLineCommand.NULL;
        }
        this.command = command.name().toLowerCase();
        this.value = null;
        this.updateWidth();
        if (command == ConfigLineCommand.UNKNOWN) {
            this.errors.add("Added unknown command");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.paddingLeft + this.width + 10);
        sb.append(this.command == null ? (char)'=' : ':');
        sb.append(KafkaStrUtil.spaces(this.paddingLeft));
        int beforeLength = sb.length();
        if (this.command != null) {
            sb.append(this.command);
        }
        if (this.value != null) {
            sb.append(this.value);
        }
        int needLength = beforeLength + this.width;
        while (sb.length() < needLength) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public boolean isValueEqualTo(String value) {
        if (ConfigLineCommand.valueOrUnknown(this.command) == ConfigLineCommand.NULL) {
            return value == null;
        }
        return Objects.equals(this.value, value);
    }
}

