/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class KafkaStrUtil {
    public static String expandStr(String value, int valueSpace) {
        if (value == null) {
            return null;
        }
        if (value.length() >= valueSpace) {
            return value;
        }
        char[] ret = new char[valueSpace];
        value.getChars(0, value.length(), ret, 0);
        for (int i = value.length(); i < valueSpace; ++i) {
            ret[i] = 32;
        }
        return new String(ret);
    }

    public static String spaces(int spaceCount) {
        char[] ret = new char[spaceCount];
        Arrays.fill(ret, ' ');
        return new String(ret);
    }

    public static int firstIndexOf(String str, char ... chars) {
        if (str == null) {
            return -1;
        }
        int[] indexes = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            indexes[i] = str.indexOf(chars[i]);
        }
        return Arrays.stream(indexes).filter(x -> x >= 0).min().orElse(-1);
    }

    public static int startSpacesCount(String str) {
        if (str == null) {
            return 0;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return str.length();
    }

    public static String findFirstContains(List<String> list, String strPart) {
        for (String str : list) {
            if (!str.contains(strPart)) continue;
            return str;
        }
        return null;
    }

    public static byte[] linesToBytes(List<String> lines) {
        if (lines == null) {
            return null;
        }
        return String.join((CharSequence)"\n", lines).getBytes(StandardCharsets.UTF_8);
    }

    public static List<String> bytesToLines(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Arrays.stream(new String(bytes, StandardCharsets.UTF_8).split("\n")).collect(Collectors.toList());
    }

    public static void addIfAbsent(List<String> list, String str) {
        if (str == null) {
            return;
        }
        for (String element : list) {
            if (!str.equals(element)) continue;
            return;
        }
        list.add(str);
    }

    public static String intToStrLen(int intValue, int strLen) {
        StringBuilder sb = new StringBuilder(strLen);
        sb.append(intValue);
        while (sb.length() < strLen) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String extractParentPath(String zNode) {
        if (zNode == null) {
            return null;
        }
        while (zNode.endsWith("/")) {
            zNode = zNode.substring(0, zNode.length() - 1);
        }
        int idx = zNode.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        if (idx == 0) {
            return "/";
        }
        String ret = zNode.substring(0, idx);
        while (ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static Integer parseIntOrNull(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    public static Long parseLongOrNull(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    public static String concat(String ... str) {
        StringBuilder ret = new StringBuilder();
        for (String s : str) {
            if (s == null) continue;
            ret.append(s);
        }
        return ret.toString();
    }

    public static String toLen(int number, int len) {
        StringBuilder ret = new StringBuilder("" + number);
        while (ret.length() < len) {
            ret.insert(0, "0");
        }
        return ret.toString();
    }

    public static String concatPath(String ... pathParts) {
        return Arrays.stream(pathParts).filter(Objects::nonNull).collect(Collectors.joining("/"));
    }
}

