/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kz.greetgo.kafka.consumer.Profile;
import kz.greetgo.kafka.consumer.TopicsInProfile;

public class KafkaTopicUtil {
    public static Set<TopicsInProfile> callAndPrepareResult(Profile defaultProfile, Method listTopicMethod, Object controller) {
        Object methodCallResult;
        try {
            methodCallResult = listTopicMethod.invoke(controller, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("lo21fT5gJ5 :: InvocationTargetException", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (methodCallResult instanceof TopicsInProfile) {
            TopicsInProfile tip = (TopicsInProfile)methodCallResult;
            return tip.profile.profile != null ? Set.of(tip) : Set.of(TopicsInProfile.of(tip.topics, defaultProfile));
        }
        if (methodCallResult instanceof CharSequence) {
            return Set.of(TopicsInProfile.of(Set.of(methodCallResult.toString()), defaultProfile));
        }
        if (methodCallResult instanceof Collection) {
            Collection collection = (Collection)methodCallResult;
            HashSet<TopicsInProfile> topics = new HashSet<TopicsInProfile>();
            for (Object topic : collection) {
                if (topic instanceof CharSequence) {
                    topics.add(TopicsInProfile.of(Set.of(topic.toString()), defaultProfile));
                    continue;
                }
                if (!(topic instanceof TopicsInProfile)) continue;
                TopicsInProfile tip = (TopicsInProfile)topic;
                if (tip.profile.profile != null) {
                    topics.add(tip);
                    continue;
                }
                topics.add(TopicsInProfile.of(tip.topics, defaultProfile));
            }
            return TopicsInProfile.distinct(topics);
        }
        throw new RuntimeException("KnhORYqB21 :: Unknown methodCallResult = " + methodCallResult);
    }

    public static Map<Profile, Set<String>> topicsToMap(Set<TopicsInProfile> prefixedTopics) {
        HashMap<Profile, Set> newMap = new HashMap<Profile, Set>();
        for (TopicsInProfile tip : prefixedTopics) {
            Profile profile = tip.profile;
            newMap.computeIfAbsent(profile, p -> new HashSet()).addAll(tip.topics);
        }
        HashMap<Profile, Set<String>> newMap2 = new HashMap<Profile, Set<String>>();
        for (Map.Entry e : newMap.entrySet()) {
            newMap2.put((Profile)e.getKey(), Set.copyOf((Collection)e.getValue()));
        }
        return newMap2;
    }
}

