/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.kafka.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;

public class NetUtil {
    public static boolean canConnectToAnyBootstrapServer(String bootstrapServers) {
        for (String hostPort : bootstrapServers.split(",")) {
            if (!NetUtil.canConnectTo(hostPort)) continue;
            return true;
        }
        return false;
    }

    public static boolean canConnectTo(String hostPort) {
        boolean bl;
        String[] split = hostPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("hostPort must contain only one comma");
        }
        String host = split[0].trim();
        int port = Integer.parseInt(split[1].trim());
        Socket socket = new Socket(host, port);
        try {
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("1\r\n\r\n".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            InputStream inputStream = socket.getInputStream();
            inputStream.read();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (e instanceof ConnectException) {
                    return false;
                }
                if (e instanceof UnknownHostException) {
                    return false;
                }
                throw new RuntimeException(e);
            }
        }
        socket.close();
        return bl;
    }
}

