/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.strconverter.simple;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.greetgo.strconverter.simple.AttrAcceptor;
import kz.greetgo.strconverter.simple.AttrGetter;
import kz.greetgo.strconverter.simple.AttrSetter;

public class AcceptorManager {
    private Map<String, AttrAcceptor> acceptorMap = new HashMap<String, AttrAcceptor>();
    private List<String> orderList = new ArrayList<String>();
    private Map<String, AttrSetter> setterMap;
    private Map<String, AttrGetter> getterMap = new HashMap<String, AttrGetter>();

    public AcceptorManager(Class<?> aClass) {
        this.setterMap = new HashMap<String, AttrSetter>();
        this.fillWithFieldSetters(aClass);
        this.fillWithMethods(aClass);
        ArrayList<String> orderList2 = new ArrayList<String>(this.orderList);
        this.orderList.clear();
        for (String name : orderList2) {
            if (this.acceptorMap.containsKey(name)) continue;
            AttrGetter getter = this.getterMap.get(name);
            AttrSetter setter = this.setterMap.get(name);
            if (getter == null || setter == null) continue;
            AttrAcceptor acceptor = new AttrAcceptor(getter, setter);
            this.acceptorMap.put(name, acceptor);
            this.orderList.add(name);
        }
        this.getterMap = null;
        this.setterMap = null;
        this.orderList = Collections.unmodifiableList(this.orderList);
    }

    public List<String> orderList() {
        return this.orderList;
    }

    public AttrAcceptor acceptor(String name) {
        return this.acceptorMap.get(name);
    }

    private void fillWithFieldSetters(Class<?> aClass) {
        for (final Field field : aClass.getFields()) {
            if (field.getAnnotation(Transient.class) != null) continue;
            this.orderList.add(field.getName());
            this.setterMap.put(field.getName(), new AttrSetter(){

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.getterMap.put(field.getName(), new AttrGetter(){

                @Override
                public Object get(Object source) {
                    try {
                        return field.get(source);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void fillWithMethods(Class<?> aClass) {
        for (final Method method : aClass.getMethods()) {
            String normName;
            Class<?> returnType;
            if (method.getAnnotation(Transient.class) != null) continue;
            int paramsCount = method.getParameterTypes().length;
            String methodName = method.getName();
            if (methodName.startsWith("get") && paramsCount == 0) {
                String normName2 = AcceptorManager.normName(methodName, 3);
                this.orderList.add(normName2);
                this.getterMap.put(normName2, new AttrGetter(){

                    @Override
                    public Object get(Object source) {
                        try {
                            return method.invoke(source, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            if (AcceptorManager.isBool(returnType = method.getReturnType()) && paramsCount == 0 && methodName.startsWith("is")) {
                normName = AcceptorManager.normName(methodName, 2);
                this.orderList.add(normName);
                this.getterMap.put(normName, new AttrGetter(){

                    @Override
                    public Object get(Object source) {
                        try {
                            return method.invoke(source, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            if (!methodName.startsWith("set") || paramsCount != 1) continue;
            normName = AcceptorManager.normName(methodName, 2);
            this.setterMap.put(normName, new AttrSetter(){

                @Override
                public void set(Object target, Object value) {
                    try {
                        method.invoke(target, value);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private static boolean isBool(Class<?> type) {
        if (type == Boolean.TYPE) {
            return true;
        }
        return type == Boolean.class;
    }

    private static String normName(String name, int prefixLen) {
        String name2 = name.substring(prefixLen);
        return name2.substring(0, 1).toLowerCase() + name2.substring(1);
    }

    public AttrAcceptor getAcceptor(String name) {
        return this.acceptorMap.get(name);
    }
}

