/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.strconverter.simple.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.greetgo.strconverter.simple.acceptors.NameValueList;
import kz.greetgo.strconverter.simple.core.ConvertRegistry;

public class Reader {
    private final ConvertRegistry convertRegistry;
    private final char[] source;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private int index = 0;

    public Reader(ConvertRegistry convertRegistry, String sourceStr) {
        this.convertRegistry = convertRegistry;
        this.source = sourceStr.toCharArray();
    }

    public <T> T read() {
        try {
            return (T)this.read0();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object read0() throws Exception {
        char commandChar = this.source[this.index++];
        switch (commandChar) {
            case 'N': {
                return null;
            }
            case 'I': {
                return Integer.valueOf(this.readNumStr());
            }
            case 'L': {
                return Long.valueOf(this.readNumStr());
            }
            case 'C': {
                return Character.valueOf(this.source[this.index++]);
            }
            case 'O': {
                return Short.valueOf(this.readNumStr());
            }
            case 'B': {
                return Byte.valueOf(this.readNumStr());
            }
            case 'F': {
                return Float.valueOf(this.readNumStr());
            }
            case 'U': {
                return Double.valueOf(this.readNumStr());
            }
            case 'D': {
                return this.sdf.parse(this.readDateStr());
            }
            case 'S': {
                return this.readAndUnquoteStr();
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return false;
            }
            case 'X': {
                return new BigDecimal(this.readNumStr());
            }
            case 'A': {
                return this.readArray(Integer.valueOf(this.readNumStr()));
            }
            case 'P': {
                return this.readListAsArrayList();
            }
            case 'G': {
                return this.readSetAsHashSet();
            }
            case 'M': {
                return this.readMapAsHashMap();
            }
            case 'Q': {
                return this.readObjectByAlias();
            }
        }
        throw new RuntimeException("Illegal command char " + commandChar);
    }

    private Object readMapAsHashMap() throws Exception {
        char openBrace;
        if ((openBrace = this.source[this.index++]) != '[') {
            throw new RuntimeException("YTWhS7HDW7U: Here must be char [");
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        while (this.source[this.index] != ']') {
            ret.put(this.read0(), this.read0());
        }
        ++this.index;
        return ret;
    }

    private Object readSetAsHashSet() throws Exception {
        char openBrace;
        if ((openBrace = this.source[this.index++]) != '[') {
            throw new RuntimeException("QTR72J6TGF: Here must be char [");
        }
        HashSet<Object> ret = new HashSet<Object>();
        while (this.source[this.index] != ']') {
            ret.add(this.read0());
        }
        ++this.index;
        return ret;
    }

    private Object readListAsArrayList() throws Exception {
        char openBrace;
        if ((openBrace = this.source[this.index++]) != '[') {
            throw new RuntimeException("BATGR517J: Here must be char [");
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        while (this.source[this.index] != ']') {
            ret.add(this.read0());
        }
        ++this.index;
        return ret;
    }

    private Object readArray(int arraySize) throws Exception {
        char closeBrace;
        char openBrace;
        Object ret = this.createArray(arraySize);
        if ((openBrace = this.source[this.index++]) != '[') {
            throw new RuntimeException("AR5162YWQ: Here must be char [");
        }
        for (int i = 0; i < arraySize; ++i) {
            Array.set(ret, i, this.read0());
        }
        if ((closeBrace = this.source[this.index++]) != ']') {
            throw new RuntimeException("Q76GR231: Here must be char ]");
        }
        return ret;
    }

    private Object createArray(int arraySize) {
        char typeChar = this.source[this.index++];
        switch (typeChar) {
            case 'S': {
                return new String[arraySize];
            }
            case 'I': {
                return new int[arraySize];
            }
            case 'L': {
                return new long[arraySize];
            }
            case 'O': {
                return new short[arraySize];
            }
            case 'C': {
                return new char[arraySize];
            }
            case 'B': {
                return new byte[arraySize];
            }
            case 'D': {
                return new Date[arraySize];
            }
            case 'F': {
                return new float[arraySize];
            }
            case 'U': {
                return new double[arraySize];
            }
            case 'Q': {
                return new Object[arraySize];
            }
            case 'J': {
                return new boolean[arraySize];
            }
            case 'X': {
                return new BigDecimal[arraySize];
            }
            case 'P': {
                return new List[arraySize];
            }
            case 'G': {
                return new Set[arraySize];
            }
            case 'M': {
                return new Map[arraySize];
            }
            case 'H': {
                String alias = this.readJavaId();
                Class<?> aClass = this.convertRegistry.aliasClassMap.get(alias);
                if (aClass == null) {
                    return new Object[arraySize];
                }
                return Array.newInstance(aClass, arraySize);
            }
        }
        throw new RuntimeException("Cannot create array for " + typeChar);
    }

    private String readAndUnquoteStr() {
        char[] source = this.source;
        int length = source.length;
        int i = this.index;
        StringBuilder sb = new StringBuilder();
        char prev = '\u0000';
        while (i < length) {
            char c;
            if ((c = source[i++]) == '\\') {
                if (prev == '\\') {
                    sb.append('\\');
                }
            } else if (c == '|') {
                if (prev != 92) break;
                sb.append('|');
            } else {
                sb.append(c);
            }
            prev = c;
        }
        this.index = i;
        return sb.toString();
    }

    private String readNumStr() {
        int i2;
        char[] source = this.source;
        int length = source.length;
        int i1 = this.index;
        for (i2 = this.index; i2 < length && this.isNumChar(source[i2]); ++i2) {
        }
        this.index = i2;
        return new String(source, i1, i2 - i1);
    }

    private String readDateStr() {
        int i2;
        char[] source = this.source;
        int length = source.length;
        int i1 = this.index;
        for (i2 = this.index; i2 < length && this.isDateChar(source[i2]); ++i2) {
        }
        this.index = i2;
        return new String(source, i1, i2 - i1);
    }

    private boolean isDateChar(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        switch (c) {
            case '-': 
            case '.': 
            case ':': 
            case 'T': {
                return true;
            }
        }
        return false;
    }

    private boolean isNumChar(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        switch (c) {
            case '+': 
            case '-': 
            case '.': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    private Object readObjectByAlias() throws Exception {
        char openBrace;
        String alias = this.readJavaId();
        if ((openBrace = this.source[this.index++]) != '{') {
            throw new RuntimeException("AQ87A2K8GYT: Here must be char {");
        }
        Class<?> objectClass = this.convertRegistry.aliasClassMap.get(alias);
        if (objectClass == null) {
            throw new RuntimeException("No alias " + alias);
        }
        if (objectClass.isEnum()) {
            char closeBrace;
            String enumStrValue = this.readJavaId();
            if ((closeBrace = this.source[this.index++]) != '}') {
                throw new RuntimeException("AJYRw8U: Here must be char }");
            }
            try {
                Object enumValue = Enum.valueOf(objectClass, enumStrValue);
                return enumValue;
            }
            catch (IllegalArgumentException | NullPointerException ignore) {
                return null;
            }
        }
        NameValueList nameValueList = new NameValueList();
        while (this.index < this.source.length) {
            char eq;
            char c = this.source[this.index];
            if (c == '}') {
                ++this.index;
                break;
            }
            String name = this.readJavaId();
            if ((eq = this.source[this.index++]) != '=') {
                throw new RuntimeException("Here must be =");
            }
            Object value = this.read0();
            if (this.source[this.index] == ',') {
                ++this.index;
            }
            nameValueList.add(name, value);
        }
        return this.convertRegistry.getAcceptorManager(alias).createInstance(nameValueList);
    }

    private String readJavaId() {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.index < this.source.length && ConvertRegistry.isJavaVariableChar(c = this.source[this.index])) {
            ++this.index;
            sb.append(c);
        }
        return sb.toString();
    }
}

