/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.strconverter.simple.acceptors;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.greetgo.strconverter.simple.acceptors.AttrAcceptor;
import kz.greetgo.strconverter.simple.acceptors.AttrGetter;
import kz.greetgo.strconverter.simple.acceptors.AttrSetter;
import kz.greetgo.strconverter.simple.acceptors.ClassManager;
import kz.greetgo.strconverter.simple.acceptors.DefaultClassInstantiation;
import kz.greetgo.strconverter.simple.acceptors.NameValueList;

public class DefaultClassManager
implements ClassManager {
    private final Class<?> workingClass;
    private final String alias;
    private Map<String, AttrAcceptor> acceptorMap = new HashMap<String, AttrAcceptor>();
    private List<String> orderList = new ArrayList<String>();
    private Map<String, AttrSetter> setterMap;
    private Map<String, AttrGetter> getterMap;

    @Override
    public Class<?> workingClass() {
        return this.workingClass;
    }

    @Override
    public String alias() {
        return this.alias;
    }

    public DefaultClassManager(Class<?> workingClass, String alias) {
        this.workingClass = workingClass;
        this.alias = alias;
        this.getterMap = new HashMap<String, AttrGetter>();
        this.setterMap = new HashMap<String, AttrSetter>();
        this.fillWithFieldSetters(workingClass);
        this.fillWithMethods(workingClass);
        ArrayList<String> orderList2 = new ArrayList<String>(this.orderList);
        this.orderList.clear();
        for (String name : orderList2) {
            if (this.acceptorMap.containsKey(name)) continue;
            AttrGetter getter = this.getterMap.get(name);
            AttrSetter setter = this.setterMap.get(name);
            if (getter == null || setter == null) continue;
            AttrAcceptor acceptor = new AttrAcceptor(getter, setter);
            this.acceptorMap.put(name, acceptor);
            this.orderList.add(name);
        }
        this.getterMap = null;
        this.setterMap = null;
        this.orderList = Collections.unmodifiableList(this.orderList);
    }

    @Override
    public List<String> orderList() {
        return this.orderList;
    }

    @Override
    public AttrAcceptor acceptor(String name) {
        return this.acceptorMap.get(name);
    }

    private void fillWithFieldSetters(Class<?> aClass) {
        for (Field field : aClass.getFields()) {
            if (field.getAnnotation(Transient.class) != null) continue;
            this.orderList.add(field.getName());
            this.setterMap.put(field.getName(), (target, value) -> {
                try {
                    field.set(target, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
            this.getterMap.put(field.getName(), source -> {
                try {
                    return field.get(source);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void fillWithMethods(Class<?> aClass) {
        for (Method method : aClass.getMethods()) {
            String normName;
            Class<?> returnType;
            if (method.getAnnotation(Transient.class) != null) continue;
            int paramsCount = method.getParameterTypes().length;
            String methodName = method.getName();
            if (paramsCount == 0 && methodName.length() > 3 && methodName.startsWith("get")) {
                String normName2 = DefaultClassManager.normName(methodName, 3);
                this.orderList.add(normName2);
                this.getterMap.put(normName2, source -> {
                    try {
                        return method.invoke(source, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            if (DefaultClassManager.isBool(returnType = method.getReturnType()) && paramsCount == 0 && methodName.length() > 2 && methodName.startsWith("is")) {
                normName = DefaultClassManager.normName(methodName, 2);
                this.orderList.add(normName);
                this.getterMap.put(normName, source -> {
                    try {
                        return method.invoke(source, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            if (paramsCount != 1 || methodName.length() <= 3 || !methodName.startsWith("set")) continue;
            normName = DefaultClassManager.normName(methodName, 3);
            this.setterMap.put(normName, (target, value) -> {
                try {
                    method.invoke(target, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static boolean isBool(Class<?> type) {
        if (type == Boolean.TYPE) {
            return true;
        }
        return type == Boolean.class;
    }

    private static String normName(String name, int prefixLen) {
        String name2 = name.substring(prefixLen);
        return name2.substring(0, 1).toLowerCase() + name2.substring(1);
    }

    @Override
    public Object createInstance(NameValueList nameValueList) {
        DefaultClassInstantiation classInstantiation = new DefaultClassInstantiation();
        return classInstantiation.createInstance(this.workingClass, this.acceptorMap, nameValueList);
    }
}

