/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.strconverter.simple.acceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kz.greetgo.strconverter.simple.acceptors.AttrAcceptor;
import kz.greetgo.strconverter.simple.acceptors.AttrGetter;
import kz.greetgo.strconverter.simple.acceptors.AttrSetter;
import kz.greetgo.strconverter.simple.acceptors.ClassInstantiation;
import kz.greetgo.strconverter.simple.acceptors.ClassManager;
import kz.greetgo.strconverter.simple.acceptors.DefaultClassInstantiation;
import kz.greetgo.strconverter.simple.acceptors.NameValueList;

public class CustomClassManager
implements ClassManager {
    private final Class<?> aClass;
    private final String alias;
    private final List<String> orderList = new ArrayList<String>();
    private final Map<String, AttrAcceptor> acceptorMap = new HashMap<String, AttrAcceptor>();
    private ClassInstantiation classInstantiation = new DefaultClassInstantiation();

    @Override
    public Class<?> workingClass() {
        return this.aClass;
    }

    @Override
    public String alias() {
        return this.alias;
    }

    private CustomClassManager(Class<?> aClass, String alias) {
        this.aClass = aClass;
        this.alias = alias;
    }

    public static CustomClassManager of(Class<?> aClass) {
        return CustomClassManager.of(aClass, aClass.getSimpleName());
    }

    public static CustomClassManager of(Class<?> aClass, String alias) {
        return new CustomClassManager(aClass, alias);
    }

    public CustomClassManager addAcceptor(String attrName, AttrAcceptor attrAcceptor) {
        Objects.requireNonNull(attrAcceptor);
        Objects.requireNonNull(attrName);
        if (this.acceptorMap.containsKey(attrName)) {
            throw new IllegalArgumentException("Attribute `" + attrName + "` already registered");
        }
        this.orderList.add(attrName);
        this.acceptorMap.put(attrName, attrAcceptor);
        return this;
    }

    public CustomClassManager addGetterAndSetter(String attrName, AttrGetter attrGetter, AttrSetter attrSetter) {
        return this.addAcceptor(attrName, new AttrAcceptor(Objects.requireNonNull(attrGetter), attrSetter));
    }

    public CustomClassManager addOnlyGetter(String attrName, AttrGetter attrGetter) {
        return this.addGetterAndSetter(attrName, Objects.requireNonNull(attrGetter), null);
    }

    public CustomClassManager setClassInstantiation(ClassInstantiation classInstantiation) {
        this.classInstantiation = classInstantiation;
        return this;
    }

    @Override
    public Object createInstance(NameValueList nameValueList) {
        return this.classInstantiation.createInstance(this.workingClass(), this.acceptorMap, nameValueList);
    }

    @Override
    public List<String> orderList() {
        return this.orderList;
    }

    @Override
    public AttrAcceptor acceptor(String name) {
        return this.acceptorMap.get(name);
    }
}

