/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.strconverter.simple.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.greetgo.strconverter.simple.acceptors.ClassManager;
import kz.greetgo.strconverter.simple.core.ConvertRegistry;
import kz.greetgo.strconverter.simple.errors.CannotSerializeClass;

public class Writer {
    private ConvertRegistry convertRegistry;
    private StringBuilder res = new StringBuilder(4096);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public Writer(ConvertRegistry convertRegistry) {
        this.convertRegistry = convertRegistry;
    }

    public Writer write(Object object) {
        this.write0(object);
        return this;
    }

    public String result() {
        return this.res.toString();
    }

    private void write0(Object object) {
        if (object == null) {
            this.res.append('N');
            return;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == Integer.class || objectClass == Integer.TYPE) {
            this.res.append('I').append(object);
            return;
        }
        if (objectClass == Long.class || objectClass == Long.TYPE) {
            this.res.append('L').append(object);
            return;
        }
        if (objectClass == Character.class || objectClass == Character.TYPE) {
            this.res.append('C').append(object);
            return;
        }
        if (objectClass == Byte.class || objectClass == Byte.TYPE) {
            this.res.append('B').append(object);
            return;
        }
        if (objectClass == Float.class || objectClass == Float.TYPE) {
            this.res.append('F').append(object);
            return;
        }
        if (objectClass == Double.class || objectClass == Double.TYPE) {
            this.res.append('U').append(object);
            return;
        }
        if (objectClass == Boolean.class || objectClass == Boolean.TYPE) {
            this.res.append((Boolean)object != false ? "J" : "K");
            return;
        }
        if (objectClass == Short.class || objectClass == Short.TYPE) {
            this.res.append('O').append(object);
            return;
        }
        if (objectClass == String.class) {
            this.res.append('S').append(Writer.quote((String)object));
            return;
        }
        if (objectClass == BigDecimal.class) {
            this.res.append('X').append(object);
            return;
        }
        if (Date.class.isAssignableFrom(objectClass)) {
            this.res.append('D').append(this.sdf.format((Date)object));
            return;
        }
        if (List.class.isAssignableFrom(objectClass)) {
            List list = (List)object;
            this.res.append("P[");
            for (Object o : list) {
                this.write0(o);
            }
            this.res.append(']');
            return;
        }
        if (Set.class.isAssignableFrom(objectClass)) {
            Set set = (Set)object;
            this.res.append("G[");
            for (Object o : set) {
                this.write0(o);
            }
            this.res.append(']');
            return;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            Map map = (Map)object;
            this.res.append("M[");
            for (Map.Entry e : map.entrySet()) {
                this.write0(e.getKey());
                this.write0(e.getValue());
            }
            this.res.append(']');
            return;
        }
        if (objectClass.isArray()) {
            if (byte[].class == objectClass) {
                String base64str = Base64.getEncoder().encodeToString((byte[])object);
                this.res.append('b').append(Writer.quote(base64str));
                return;
            }
            if (char[].class == objectClass) {
                String str = new String((char[])object);
                this.res.append('c').append(Writer.quote(str));
                return;
            }
            String arrayType = this.getArrayTypeId(objectClass);
            int length = Array.getLength(object);
            this.res.append('A').append(length).append(arrayType).append('[');
            for (int i = 0; i < length; ++i) {
                this.write0(Array.get(object, i));
            }
            this.res.append(']');
            return;
        }
        String alias = this.convertRegistry.classAliasMap.get(objectClass);
        if (alias != null) {
            if (objectClass.isEnum()) {
                Enum e = (Enum)object;
                this.res.append('Q').append(alias).append('{').append(e.name()).append('}');
                return;
            }
            this.res.append('Q').append(alias).append('{');
            ClassManager classManager = this.convertRegistry.getAcceptorManager(objectClass);
            int len = this.res.length();
            for (String attrName : classManager.orderList()) {
                Object attrValue = classManager.acceptor(attrName).get(object);
                if (attrValue == null) continue;
                this.res.append(attrName).append('=');
                this.write0(attrValue);
                this.res.append(',');
            }
            if (len < this.res.length()) {
                this.res.setLength(this.res.length() - 1);
            }
            this.res.append('}');
            return;
        }
        throw new CannotSerializeClass(object.getClass());
    }

    private String getArrayTypeId(Class<?> objectClass) {
        if (objectClass == int[].class) {
            return "I";
        }
        if (objectClass == long[].class) {
            return "L";
        }
        if (objectClass == short[].class) {
            return "O";
        }
        if (objectClass == char[].class) {
            return "C";
        }
        if (objectClass == byte[].class) {
            return "B";
        }
        if (objectClass == boolean[].class) {
            return "J";
        }
        if (objectClass == BigDecimal[].class) {
            return "X";
        }
        if (objectClass == double[].class) {
            return "U";
        }
        if (objectClass == float[].class) {
            return "F";
        }
        if (objectClass == Object[].class) {
            return "Q";
        }
        if (objectClass == String[].class) {
            return "S";
        }
        if (objectClass == List[].class) {
            return "P";
        }
        if (objectClass == Date[].class) {
            return "D";
        }
        if (objectClass == Map[].class) {
            return "M";
        }
        if (objectClass == Set[].class) {
            return "G";
        }
        return "H" + this.convertRegistry.getAliasForOrThrowError(objectClass.getComponentType());
    }

    private static String quote(String str) {
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '|': {
                    sb.append("\\|");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('|');
        return sb.toString();
    }
}

