package kz.greetgo.script.model.block.con1;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.flow.FieldPointer;
import lombok.ToString;

@ToString
@KafkaModel
public class BlockSetField extends BlockCon {

  public String leftExprId;

  public String rightExprId;

  public Map<String, FieldPointer> fieldPointers = new HashMap<>();

  public Map<String, FieldPointer> fieldPointers() {
    var x = fieldPointers;
    return x != null ? x : (fieldPointers = new HashMap<>());
  }

  public static BlockSetField of(String leftExprId, String rightExprId) {
    BlockSetField ret = new BlockSetField();
    ret.leftExprId  = leftExprId;
    ret.rightExprId = rightExprId;
    return ret;
  }

  public BlockSetField down(String downBlockId) {
    this.downBlockId = downBlockId;
    return this;
  }

  public BlockSetField field(String fieldId) {
    double maxOrderIndex = fieldPointers().values().stream().mapToDouble(x -> x.orderIndex).max().orElse(0);

    float  newOrderIndex = (float) maxOrderIndex + 1;
    String newId         = "bfp_" + newOrderIndex;

    FieldPointer fieldPointer = new FieldPointer();
    fieldPointer.fieldId    = fieldId;
    fieldPointer.orderIndex = newOrderIndex;
    fieldPointers().put(newId, fieldPointer);

    return this;
  }
}
