package kz.greetgo.script.model.block.fix;

import kz.greetgo.kafka.model.KafkaModel;
import lombok.ToString;

@ToString
@KafkaModel
public class BlockFixEntryPoint extends BlockFix {
  public String downBlockId;

  public static BlockFixEntryPoint of(float x, float y, String downBlockId) {
    return BlockFixEntryPoint.of(x, y).down(downBlockId);
  }

  public static BlockFixEntryPoint of(float x, float y) {
    var b = new BlockFixEntryPoint();
    b.x = x;
    b.y = y;
    return b;
  }

  public BlockFixEntryPoint down(String downBlockId) {
    this.downBlockId = downBlockId;
    return this;
  }

}
