package kz.greetgo.script.model.bo_code;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Builder;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

@Builder
@ToString
@RequiredArgsConstructor
public class BoDefinition {
  public final String id;
  public final String code;
  public final String name;

  public final Map<String, BoFieldDefinition> fieldsByCode;

  public final boolean     isCo;
  public final Set<String> containsBoIds;
  public final boolean     isProcess;

  public static Map<String, BoFieldDefinition> overlapFields(BoFieldDefinition... fields) {
    Map<String, BoFieldDefinition> ret = new HashMap<>();
    for (final BoFieldDefinition field : fields) {
      ret.put(field.code, field);
    }
    return Map.copyOf(ret);
  }

  public Optional<BoFieldDefinition> fieldByCode(String fieldCode) {
    return fieldCode == null || fieldsByCode == null
      ? Optional.empty()
      : Optional.ofNullable(fieldsByCode.get(fieldCode));
  }
}
