package kz.greetgo.script.model.context.act;

import java.util.Optional;
import kz.greetgo.mybpm_util_light.filter.StrFilter;
import kz.greetgo.mybpm_util_light.filter.StrFilterResult;
import kz.greetgo.script.model.expr.flow.act.ActId;
import kz.greetgo.script.model.expr.flow.act.ActLocalId;
import kz.greetgo.script.model.expr.flow.act.ActRecord;
import kz.greetgo.script.model.expr.flow.act.ActSourceId;
import lombok.Builder;
import lombok.ToString;

@Builder
@ToString
public class ActDisplay {
  public final ActLocalId localId;
  public final String     displayStr;

  public Optional<ActRecord> filter(ActSourceId actSourceId, StrFilter strFilter, String filter) {
    StrFilterResult filterResult = strFilter.filter(filter, displayStr);
    if (!filterResult.found) {
      return Optional.empty();
    }
    {
      ActId     actId     = ActId.dynamic(actSourceId, localId);
      ActRecord actRecord = new ActRecord();
      actRecord.id         = actId.strValue();
      actRecord.displayStr = filterResult.markedFindStr;
      return Optional.of(actRecord);
    }
  }

}
