package kz.greetgo.script.model.context.controller.func;

import kz.greetgo.script.ann.Author;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.signature.MybpmFile;

@FuncName("Работа с бизнес-объектами")
@FuncDescription("Работа с бизнес-объектами")
public interface BoFuncController {

  @FuncName("Добавить к множественному полю")
  @FuncDescription("К полю бизнес-объекта, которое содержит ссылки на несколько экземпляров бизнес-объекта, добавить ещё один экземпляр")
  @Author("Колпаков Евгений Анатольевич")
  void addRefToField(

    @FuncParamName("к полю")
    @FuncParamDescription("Ссылка на поле в инстанции бизнес-объекта, к которому нужно добавить экземпляр")
    BoiFieldRef toField,

    @FuncParamName("экземпляр")
    @FuncParamType(ValueType.Bo)
    @FuncParamDescription("Экземпляр бизнес-объекта. Этот экземпляр должен принадлежать тому же бизнес-объекту," +
      " которому соответствует поле из первого аргумента")
    BoiRef boiRef
  );

  @FuncName("Удалить из множественного поля")
  @FuncDescription("У поля бизнес-объекта, которое содержит ссылки на несколько экземпляров бизнес-объекта, удалить один экземпляр")
  @Author("Колпаков Евгений Анатольевич")
  void delRefToField(

    @FuncParamName("у пол")
    @FuncParamDescription("Ссылка на поле в инстанции бизнес-объекта, из которого нужно удалить экземпляр")
    BoiFieldRef toField,

    @FuncParamName("экземпляр")
    @FuncParamType(ValueType.Bo)
    @FuncParamDescription("Экземпляр бизнес-объекта. Этот экземпляр должен принадлежать тому же бизнес-объекту," +
      " которому соответствует поле из первого аргумента")
    BoiRef boiRef
  );

  @FuncName("Удалить экземпляр")
  @FuncDescription("У экземпляр бизнес-объекта")
  void removeBoi(

    @FuncParamName("экземпляр")
    @FuncParamDescription("Экземпляр бизнес-объекта.")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef

  );

  @FuncName("Добавить к полю файл")
  @FuncDescription("К полю бизнес-объекта 'Загрузка файла' добавить один файл")
  @Author("Елетай Ерасыл")
  void addFileToField(

    @FuncParamName("к полю")
    @FuncParamDescription("Ссылка на поле в инстанции бизнес-объекта, к которому нужно добавить файл")
      BoiFieldRef toField,

    @FuncParamName("файл")
    @FuncParamType(ValueType.Object)
    @FuncParamDescription("Файл")
      MybpmFile mybpmFile
  );

  @FuncName("Удалить с поля файл")
  @FuncDescription("С поля бизнес-объекта 'Загрузка файла' удалить один файл")
  @Author("Елетай Ерасыл")
  void delFileFromField(

    @FuncParamName("с поля")
    @FuncParamDescription("Ссылка на поле в инстанции бизнес-объекта, с которой нужно удалить файл")
      BoiFieldRef toField,

    @FuncParamName("файл")
    @FuncParamType(ValueType.Object)
    @FuncParamDescription("Файл")
      MybpmFile mybpmFile
  );

}
