package kz.greetgo.script.model.context.controller.func;

import java.math.BigDecimal;
import java.util.Date;
import kz.greetgo.script.ann.Author;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.func.FuncReturnDescription;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.Period;

@FuncName("Работа с датами")
@FuncDescription("Работа с датами")
public interface DatesFuncController {

  @FuncName("Увеличить на месяцы")
  @FuncDescription("Увеличивает дату на указанное количество месяцев (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incDateMonths(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("месяцев")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество месяцев, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Увеличить на минуты")
  @FuncDescription("Увеличивает дату на указанное количество минут (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incDateMinutes(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("мин")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество минут, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Увеличить на дни")
  @FuncDescription("Увеличивает дату на указанное количество дней (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incDateDays(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("дней")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество дней, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Равны ли даты по ГМД")
  @FuncDescription("Сравнивает дату только по годам, месяцам и дням. Время не участвует в сравнении")
  @FuncReturnDescription("Возвращает `Да`, если года, дни и месяцы указанных дат одинаковые. Иначе, возвращает `Нет`.")
  @Author("Колпаков Евгений Анатольевич")
  boolean eqDateYMD(

    @FuncParamName("дата1")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Первая дата для сравнения")
    Date date1,

    @FuncParamName("дата2")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Вторая дата для сравнения")
    Date date2

  );


  @FuncName("Сейчас")
  @FuncDescription("Возвращает текущую дату и время")
  @FuncReturnDescription("Текущая дата и время")
  @Author("Колпаков Евгений Анатольевич")
  Date now();

  @FuncName("Разница в годах")
  @FuncDescription("Сравнивает две даты, если одна из даты пустая, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает разницу в годах")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal diffYears(

    @FuncParamName("большая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Большая дата")
    Date date2,

    @FuncParamName("меньшая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Меньшая дата")
    Date date1
  );

  @FuncName("Разница в месяцах")
  @FuncDescription("Сравнивает две даты, если одна из даты пустая, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает разницу в месяцах")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal diffMonth(

    @FuncParamName("большая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("большая дата")
    Date date2,

    @FuncParamName("меньшая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Меньшая дата")
    Date date1
  );

  @FuncName("Разница в днях")
  @FuncDescription("Сравнивает две даты, если одна из даты пустая, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает разницу в днях")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal diffDays(

    @FuncParamName("большая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("большая дата")
    Date date2,

    @FuncParamName("меньшая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("меньшая дата")
    Date date1
  );

  @FuncName("Разница в часах")
  @FuncDescription("Сравнивает две даты, если одна из даты пустая, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает разницу в часах")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal diffHours(

    @FuncParamName("большая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Большая дата")
    Date date2,

    @FuncParamName("меньшая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Меньшая дата")
    Date date1
  );

  @FuncName("Разница в минутах")
  @FuncDescription("Сравнивает две даты, если одна из даты пустая, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает разницу в минутах")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal diffMinutes(

    @FuncParamName("большая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Большая дата")
    Date date2,

    @FuncParamName("меньшая дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Меньшая дата")
    Date date1
  );

  @FuncName("Первая дата из периода")
  @FuncDescription("Берет первую дату из периода, если период пустой, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает первую дату из периода")
  @Author("anukenov")
  Date firstDateFromPeriod(

    @FuncParamName("период")
    @FuncParamType(ValueType.Period)
    @FuncParamDescription("Период")
    Period period

  );

  @FuncName("Вторая дата из периода")
  @FuncDescription("Берет вторая дату из периода, если период пустой, то ошибку сбрасывает")
  @FuncReturnDescription("Возвращает вторая дату из периода")
  @Author("anukenov")
  Date secondDateFromPeriod(

    @FuncParamName("период")
    @FuncParamType(ValueType.Period)
    @FuncParamDescription("Период")
    Period period

  );

  @FuncName("Увеличить на рабочие месяцы")
  @FuncDescription("Увеличивает дату на указанное количество месяцев (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incWorkingDateMonths(

    @FuncParamName("Для пользователя/департамента/рабочей группы/компании")
    @FuncParamDescription("Ссылка на пользователя/департамента/рабочей группы/компании")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("месяцев")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество месяцев, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Увеличить на рабочие дни")
  @FuncDescription("Увеличивает дату на указанное количество дней (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incWorkingDateDays(

    @FuncParamName("Для пользователя/департамента/рабочей группы/компании")
    @FuncParamDescription("Ссылка на пользователя/департамента/рабочей группы/компании")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("дней")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество дней, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Увеличить на рабочие часы")
  @FuncDescription("Увеличивает дату на указанное количество часов (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incWorkingDateHours(

    @FuncParamName("Для пользователя/департамента/рабочей группы/компании")
    @FuncParamDescription("Ссылка на пользователя/департамента/рабочей группы/компании")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
    Date source,

    @FuncParamName("часов")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество часов, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
    BigDecimal amount
  );

  @FuncName("Увеличить на рабочие минуты")
  @FuncDescription("Увеличивает дату на указанное количество минут (или уменьшает, если передать отрицательное число)")
  @FuncReturnDescription("Увеличенная дата")
  @Author("Колпаков Евгений Анатольевич")
  Date incWorkingDateMinutes(

    @FuncParamName("Для пользователя/департамента/рабочей группы/компании")
    @FuncParamDescription("Ссылка на пользователя/департамента/рабочей группы/компании")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Исходная дата, которая будет увеличена и возвращена (сама дата не изменяется)")
      Date source,

    @FuncParamName("минут")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Количество минут, на которое нужно увеличить исходную дату, или уменьшить, если передать отрицательное число")
      BigDecimal amount
  );

  @FuncName("Дата заполнена?")
  @FuncDescription("Проверяет дату, если дата пустая, то возвращает `Нет`")
  @FuncReturnDescription("Возвращает `Да` либо `Нет`")
  @Author("Сахи Нурлыбек Кикбайулы")
  boolean checkDate(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, которая проверяется на пустоту")
      Date date
  );

  @FuncName("Входит ли")
  @FuncDescription("Проверяет входит ли дата в диапазон с и по. Если входит, то возвращает `Да`, иначе возвращает `Нет`." +
    " В случае если одна из указанных дат пустая, то всегда возвращает `Нет`")
  @FuncReturnDescription("Возвращает `Да` либо `Нет`")
  @Author("Сахи Нурлыбек Кикбайулы")
  boolean checkDateRange(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, которая проверяется входит ли в диапазон 'Меньшая дата' и 'Большая дата'")
      Date date,

    @FuncParamName("с")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Меньшая дата")
      Date date1,

    @FuncParamName("по")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Большая дата")
      Date date2
  );

  @FuncName("Получить год")
  @FuncDescription("Возвращает год с даты")
  @FuncReturnDescription("Год в виде числа")
  @Author("yyeletay")
  BigDecimal getYear(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, с которой надо получить год")
      Date date

  );

  @FuncName("Получить месяц (1-12)")
  @FuncDescription("Возвращает месяц с даты")
  @FuncReturnDescription("Месяц в виде числа (1-12)")
  @Author("yyeletay")
  BigDecimal getMonth(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, с которой надо получить месяц")
      Date date

  );

  @FuncName("Получить день месяца")
  @FuncDescription("Возвращает день с даты")
  @FuncReturnDescription("День месяца в виде числа")
  @Author("yyeletay")
  BigDecimal getDay(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, с которой надо получить день месяца")
      Date date

  );

  @FuncName("Текущий год")
  @FuncDescription("Возвращает текущий год")
  @FuncReturnDescription("Текущий год")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal currentYear();

  @FuncName("Текущий месяц")
  @FuncDescription("Возвращает текущий месяц")
  @FuncReturnDescription("Текущий месяц в виде числа(1-12)")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal currentMonth();

  @FuncName("Текущий день")
  @FuncDescription("Возвращает текущий день")
  @FuncReturnDescription("Текущий день в виде числа(1-31)")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal currentDay();

  @FuncName("Получить день недели(1-7)")
  @FuncDescription("Возвращает день недели с даты")
  @FuncReturnDescription("День недели в виде числа(1-7)")
  @Author("Сахи Нурлыбек Кикбайулы")
  BigDecimal getDayOfWeek(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Дата, с которой надо получить день недели")
      Date date
  );


  @FuncName("Собрать дату и время")
  @FuncDescription("Собирает дату и время, из двух аругментов: из одного берет только дату, из второго берет только время")
  @FuncReturnDescription("Собранная дата и время")
  @Author("Сахи Нурлыбек Кикбайулы")
  Date assembleDateWithTime(

    @FuncParamName("дата")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Из этого аргумента берется только дата")
      Date date,

    @FuncParamName("время")
    @FuncParamType(ValueType.Date)
    @FuncParamDescription("Из этого аргумента берется только время")
      Date time
  );

}
