package kz.greetgo.script.model.context.model;

import kz.greetgo.mybpm.model_web.web_dynamic_forms.BoInstanceId;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

@ToString
@Data
@EqualsAndHashCode
@NoArgsConstructor
@AllArgsConstructor
public class BoiFieldRef {
  public String boId;
  public String fieldId;
  public String boiId;

  public static BoiFieldRef of(String boId, String boiId, String fieldId) {
    BoiFieldRef ret = new BoiFieldRef();
    ret.boId    = boId;
    ret.boiId   = boiId;
    ret.fieldId = fieldId;
    return ret;
  }

  public static BoiFieldRef of(BoiRef boiRef, String fieldId) {
    return of(boiRef.boId, boiRef.boiId, fieldId);
  }

  public static BoiFieldRef of(BoInstanceId instanceId, String fieldId) {
    return of(instanceId.boId, instanceId.boiId, fieldId);
  }

  public BoiRef readBoiRef() {
    return BoiRef.of(boId, boiId);
  }



}
