package kz.greetgo.script.model.context.model.signature;

import java.util.Date;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.ann.object.ObjectCreateMethodName;
import kz.greetgo.script.ann.object.ObjectDescription;
import kz.greetgo.script.ann.object.ObjectFieldType;
import kz.greetgo.script.ann.object.ObjectFieldUseSetter;
import kz.greetgo.script.ann.object.ObjectMethodIgnore;
import kz.greetgo.script.ann.object.ObjectName;
import kz.greetgo.script.ann.object.ObjectNativeName;
import kz.greetgo.script.model._interface.FileUtil;

@ObjectName("Документ")
@ObjectNativeName("MybpmFile")
@ObjectCreateMethodName("createMybpmFile")
@ObjectDescription("Документ")
public class MybpmFile {

  private final FileUtil fileUtil;

  public String id;

  @ObjectName("Название файла")
  @ObjectDescription("Название файла")
  @ObjectFieldType(ValueType.Text)
  @ObjectFieldUseSetter
  public String name;

  @ObjectName("Тип файла")
  @ObjectDescription("Тип файла")
  @ObjectFieldType(ValueType.EnumRef)
  public MybpmFileType type;

  @ObjectName("Дата создания")
  @ObjectDescription("Дата создания")
  @ObjectFieldType(ValueType.Date)
  public Date createdAt;

  public MybpmFile(FileUtil fileUtil) {
    this.fileUtil = fileUtil;
  }

  @ObjectMethodIgnore
  public void setName(String name) {
    if (name == null || name.isBlank()) {
      name = "file";
    }

    if (this.name == null) {
      this.name = "file.png";
    }

    int dotIndex = this.name.lastIndexOf(".");

    this.name = name + this.name.substring(dotIndex);

    fileUtil.renameFile(id, this.name);
  }

}
