package kz.greetgo.script.model.definitions.object;

import java.util.HashMap;
import java.util.Map;
import lombok.ToString;

import static java.util.stream.Collectors.toMap;

@ToString
public class ObjectsDefinition {
  public Map<String, ObjectDefinition> objects = new HashMap<>();

  public ObjectsDefinition onlyEnabled() {

    ObjectsDefinition ret = new ObjectsDefinition();

    ret.objects = this.objects.entrySet().stream()
                              .filter(x -> !x.getValue().disabled)
                              .collect(toMap(Map.Entry::getKey, Map.Entry::getValue));

    return ret;

  }

}
