package kz.greetgo.script.model.expr.flow;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.flow.act.ActId;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

@ToString
@KafkaModel
@FieldNameConstants
public class ExprAct extends Expr {
  public String  leftExprId;
  public String  actId;
  public boolean canWriteValue;

  public Map<String, String> argExprIds;

  public static ExprAct of(String leftExprId) {
    ExprAct ret = new ExprAct();
    ret.leftExprId = leftExprId;
    return ret;
  }

  public ExprAct actId(ActId actId) {
    this.actId = actId.strValue();
    return this;
  }

  public ExprAct actId(String actId) {
    this.actId = actId;
    return this;
  }

  public ExprAct canWriteValue(boolean canWriteValue) {
    this.canWriteValue = canWriteValue;
    return this;
  }

  public ExprAct arg(String argId, String argExprId) {
    if (argExprIds == null) {
      argExprIds = new HashMap<>();
    }
    argExprIds.put(argId, argExprId);
    return this;
  }
}
