package kz.greetgo.script.model.expr.flow;

import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.enums.GetVarType;
import lombok.ToString;

@ToString
@KafkaModel
public class ExprVar extends Expr {
  /**
   * Тип переменной
   */
  public GetVarType varType;

  /**
   * Идентификатор аргумента метода (используется если varType === Arg)
   */
  public String argId;

  /**
   * Идентификатор блока, в котором эта переменная создана (используется если varType === Local)
   */
  public String blockId;

  /**
   * Идентификатор внешней переменной (используется если varType === Extern)
   */
  public String externVarId;

  public static ExprVar localRef(String blockId) {
    ExprVar e = new ExprVar();
    e.varType = GetVarType.Local;
    e.blockId = blockId;
    return e;
  }

  public static Expr externRef(String externVarId) {
    ExprVar e = new ExprVar();
    e.varType     = GetVarType.Extern;
    e.externVarId = externVarId;
    return e;
  }
}
