package kz.greetgo.script.model.util;

import java.util.function.Supplier;
import lombok.RequiredArgsConstructor;

/**
 * Вычисляет значение один раз.
 * <p>
 * При этом встроена защита от рекурсивного зацикливания.
 * <p>
 * Если обнаружено зацикливание, то возвращается null.
 *
 * @param <T> тип вычисляемого один раз значения
 */
@RequiredArgsConstructor
public class CalcOnce<T> {
  private final Supplier<T> supplier;

  private boolean calculated    = false;
  private boolean inCalculation = false;

  private T calculatedValue;

  public T get() {

    if (inCalculation) {
      calculated = true;
      System.err.println("NDEg9Sb12x :: Circle calculation");
      return null;
    }

    if (calculated) {
      return calculatedValue;
    }

    inCalculation = true;
    try {

      var x = calculatedValue = supplier.get();
      calculated = true;
      return x;

    } finally {
      inCalculation = false;
    }
  }
}
