/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.bo_code;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kz.greetgo.script.model.bo_code.BoFieldDefinition;

public class BoDefinition {
    public final String id;
    public final String code;
    public final String name;
    public final Map<String, BoFieldDefinition> fieldsByCode;
    public final boolean isCo;
    public final Set<String> containsBoIds;
    public final boolean isProcess;

    public static Map<String, BoFieldDefinition> overlapFields(BoFieldDefinition ... fields) {
        HashMap<String, BoFieldDefinition> ret = new HashMap<String, BoFieldDefinition>();
        for (BoFieldDefinition field : fields) {
            ret.put(field.code, field);
        }
        return Map.copyOf(ret);
    }

    public Optional<BoFieldDefinition> fieldByCode(String fieldCode) {
        return fieldCode == null || this.fieldsByCode == null ? Optional.empty() : Optional.ofNullable(this.fieldsByCode.get(fieldCode));
    }

    public static BoDefinitionBuilder builder() {
        return new BoDefinitionBuilder();
    }

    public String toString() {
        return "BoDefinition(id=" + this.id + ", code=" + this.code + ", name=" + this.name + ", fieldsByCode=" + this.fieldsByCode + ", isCo=" + this.isCo + ", containsBoIds=" + this.containsBoIds + ", isProcess=" + this.isProcess + ")";
    }

    public BoDefinition(String id, String code, String name, Map<String, BoFieldDefinition> fieldsByCode, boolean isCo, Set<String> containsBoIds, boolean isProcess) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.fieldsByCode = fieldsByCode;
        this.isCo = isCo;
        this.containsBoIds = containsBoIds;
        this.isProcess = isProcess;
    }

    public static class BoDefinitionBuilder {
        private String id;
        private String code;
        private String name;
        private Map<String, BoFieldDefinition> fieldsByCode;
        private boolean isCo;
        private Set<String> containsBoIds;
        private boolean isProcess;

        BoDefinitionBuilder() {
        }

        public BoDefinitionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BoDefinitionBuilder code(String code) {
            this.code = code;
            return this;
        }

        public BoDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BoDefinitionBuilder fieldsByCode(Map<String, BoFieldDefinition> fieldsByCode) {
            this.fieldsByCode = fieldsByCode;
            return this;
        }

        public BoDefinitionBuilder isCo(boolean isCo) {
            this.isCo = isCo;
            return this;
        }

        public BoDefinitionBuilder containsBoIds(Set<String> containsBoIds) {
            this.containsBoIds = containsBoIds;
            return this;
        }

        public BoDefinitionBuilder isProcess(boolean isProcess) {
            this.isProcess = isProcess;
            return this;
        }

        public BoDefinition build() {
            return new BoDefinition(this.id, this.code, this.name, this.fieldsByCode, this.isCo, this.containsBoIds, this.isProcess);
        }

        public String toString() {
            return "BoDefinition.BoDefinitionBuilder(id=" + this.id + ", code=" + this.code + ", name=" + this.name + ", fieldsByCode=" + this.fieldsByCode + ", isCo=" + this.isCo + ", containsBoIds=" + this.containsBoIds + ", isProcess=" + this.isProcess + ")";
        }
    }
}

